var curPage = 1, pageSize = 10;
$(function () {
    to_page(0);
})

function to_page(T) {
    getPageParams(T);
    $.ajax({
        url: "getList",
        data: formdata,
        type: "POST",
        dataType: "json",
        processData: false,
        contentType: false,
        success: function (result) {
            if (result.list.length == 0 && curPage > 1) {
                curPage--;
                to_page(1);
            } else {
                build_info_table(result.list);
                setPage(result.page);
            }
            $(".layui-form-checked").removeClass('layui-form-checked');

        }
    });
}

function getPageParams(T) {
    if (T == 0) {
        var form = document.querySelector("#formId");
        formdata = new FormData(form);
    }
    formdata.set("curPage", curPage);
    formdata.set("pageSize", pageSize);
    getOtherParams();
}

function getOtherParams() {

}

function setPage(page) {
    layui.use(['laypage', 'layer'], function () {
        var laypage = layui.laypage;
        //执行一个laypage实例
        laypage.render({
            elem: 'laypage',
            count: page.rowsCount,
            limit: pageSize,
            layout: ['count', 'prev', 'page', 'next', 'limit', 'skip'],
            limits: [10, 20, 30, 50, 100],
            groups: 10,
            curr: page.curPage,
            jump: function (obj, first) {
                //首次不执行
                if (!first) {
                    curPage = obj.curr;
                    pageSize = obj.limit;
                    //回调该展示数据的方法,数据展示
                    to_page(1);
                }
            }
        });
    });
}

//根据id删除
function delById(ids) {
    if (ids == 0) {
        ids = tableCheck.getData();
        if (ids == '') {
            layer.msg('请至少选择一条数据!', {icon: 2});
            return false;
        }
    }
    layer.confirm('确定要删除吗？', function (index) {
        $.ajax({
            url: "delById",
            data: {"ids": ids},
            type: "POST",
            dataType: "json",
            success: function (result) {
                if (result.success) {
                    layer.msg(result.msg, {icon: 6, time: 1000}, function () {
                        to_page(1);
                    });
                } else {
                    layer.msg(result.msg, {icon: 5, time: 1000});
                }

            }
        });

    });
}


function layerOpen(w, h, title, id) {
    layer.open({
        type: 2,
        area: [w + 'px', h + 'px'],
        fix: false, //不固定
        maxmin: true,
        shadeClose: true,
        shade: 0.4,
        title: title,
        content: 'addOrEdit?id=' + id,
        end: function () {
            to_page(1);
        }
    });
}