package com.yunniu.farming.webadmin.service.impl;


import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.dao.SysSetDao;
import com.yunniu.farming.webadmin.model.Banner;
import com.yunniu.farming.webadmin.model.SysSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class SysSetServiceImpl {


	@Autowired
	private SysSetDao sysSetDao;
	
	/**
	 * 增加/修改
	 */
	public Result add(SysSet item){
		//判断id是否为空，如果为空则直接插入，否则更新
		if(item.getId() == null){

			//增量保存
			this.sysSetDao.insert(item);
			
		}else{
			//修改
			this.sysSetDao.updateById(item);
		}
		
		return Result.success(item);
	}


	/**
	* 更新 方法
	*/
	public int update(SysSet item){

		if(item.getId() == null) return -1;
			
		return this.sysSetDao.updateById(item);
	}


	/**
	 * 根据id查找
	 * @param id
	 * @return
	 */
	public Result finById(Integer id){
		SysSet u = this.sysSetDao.selectById(id);
		return Result.success(u);
	}



    /**
     * 带参 查询列表
     * @param item
     * @return
     */
    public List<SysSet> findByParam(SysSet item){
        List<SysSet> items = this.sysSetDao.selectByParam(item);
        return items;
    }






	public SysSet findByParam(){
		List<SysSet> items = this.sysSetDao.selectByParam(new SysSet());
		return items.get(0);
	}



	public Banner getBanner() {
		return sysSetDao.getBanner();
	}


}
