package com.yunniu.farming.webadmin.service.impl;

import com.yunniu.farming.result.Result;
import com.yunniu.farming.util.*;
import com.yunniu.farming.webadmin.dao.ProductDao;
import com.yunniu.farming.webadmin.model.Product;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;


@Service
public class ProductServiceImpl {
	
	/**
	 * 注册 dao 接口
	 */
	@Autowired
	private ProductDao productDao;


	//-------------------增、删、改、查 方法---------------------
	/**
	 * 增加、编辑 同一个方法
	 */
	public Result add(Product item){
		
		//1. 判断id是否为空，如果为空则直接插入，否则更新
		if(item.getId() == null || item.getId().equals("")){

			item.setId(null);
			//创建时间、日期
			item.setScreatedate(DateTools.getDate("yyyy-MM-dd"));
			item.setTcreatetime(new Date());

			String[] imgArr = item.getGoodsImgArr();
			String pics = "";
			if (imgArr != null && imgArr.length > 0) {
				for (int i = 0; i < imgArr.length; i++) {
					if (imgArr[i].startsWith("data:image")) {
						String suffix = imgArr[i].substring(imgArr[i].indexOf("/") + 1, imgArr[i].indexOf(";"));
						String realpath = FileUtil.BasePath + "/goods/" + UUIDUtils.getUUID() + "." + suffix;
						if (ImageUtil.GenerateImage(imgArr[i + 1], realpath)) {
							String url = COSUtil.uploadFileByPath(realpath);
							if ("".equals(pics)) {
								pics = url;
							} else {
								pics = pics + "," + url;
							}
						}
					}
				}
			}
			if ("".equals(pics)) {
				return Result.error("图片不能为空!");
			}
			item.setSsharepic(pics);
			if (pics.indexOf(",") > -1) {
				item.setSshortpic(pics.substring(0, pics.indexOf(",")));
			} else {
				item.setSshortpic(pics);
			}

			// 增量保存
			this.productDao.insert(item);

		}else{

			Product oldGoods = productDao.selectByPrimaryKey(item.getId());
			String[] picArr = item.getGoodsImgArr();
			String pics = "";
			if (picArr != null && picArr.length > 0) {
				for (int i = 0; i < picArr.length; i++) {
					if (picArr[i].startsWith("data:image")) {
						String suffix = picArr[i].substring(picArr[i].indexOf("/") + 1, picArr[i].indexOf(";"));
						String realpath = FileUtil.BasePath + "/goods/" + UUIDUtils.getUUID() + "." + suffix;
						if (ImageUtil.GenerateImage(picArr[i + 1], realpath)) {
							String url = COSUtil.uploadFileByPath(realpath);
							FileUtil.deleteFilesByRealPath(realpath);
							if ("".equals(pics)) {
								pics = url;
							} else {
								pics = pics + "," + url;
							}
						} else {
							return new Result().error("图片存储出错!");
						}
					} else if (picArr[i].startsWith("http")) {
						picArr[i] = picArr[i].replace("amp;", "");
						if ("".equals(pics)) {
							pics = picArr[i];
						} else {
							pics = pics + "," + picArr[i];
						}
					}
				}
			}
			item.setSsharepic(pics);
			if (pics.indexOf(",") > -1) {
				item.setSshortpic(pics.substring(0, pics.indexOf(",")));
			} else {
				item.setSshortpic(pics);
			}

			//id 为空，则调用 更新方法
			this.productDao.updateById(item);

		}
		return Result.success(item);
	}



	
	/**
	 * 根据id查找对象
	 */
	public Product findByid(int id){

		return this.productDao.selectByPrimaryKey(id);

	}
	
	/**
	 * 根据id删除
	 */
	public Result deleteByid(int id){
		int deleteR = this.productDao.deleteByPrimaryKey(id);
        if (deleteR > 0) {
            return Result.success("删除成功");
        }
        return Result.error();
	}

	
   /**
	 * 更新 方法
	 */
	public Result update(Product item){

		if(item.getId() == null) return Result.error("id为空");

        int i = this.productDao.updateById(item);

        if(i > 0){
            return Result.success("更新成功");
        }else {
            return Result.error();
        }

	}
	
	/**
	 * 根据 多参数 查找对象集合
	 */
	public List<Product> findByParam(Product item){
		List<Product> items = this.productDao.selectByParam(item);
		return items;
	}
	

	
	/**
	 * 根据 多参数  分页查找对象集合
	 * @return
	 */
	public List<Product> findByParamPageList(Product main){
		return this.productDao.selectByParamPageList(main);
	}




	//-------------------其他方法---------------------


	//推荐商品
	public List<Product> findByParamHotPageList(Product main){
		return this.productDao.selectByParamHotPageList(main);
	}

	//折扣商品
	public List<Product> findByParamZkPageList(Product main){
		return this.productDao.selectByParamZkPageList(main);
	}


	/**
	 * 上下架
	 */
	public Result updateStatus(Product item){

		if(item.getId() == null) return Result.error("id为空");

		if(item.getIstatus() == null) return Result.error("商品状态为空");

		int i = this.productDao.updateById(item);

		if(i > 0){
			return Result.success("更新成功");
		}else {
			return Result.error();
		}

	}


    public List<Product> findByParamIntePageList(Product item) {
		return this.productDao.selectByParamIntePageList(item);
    }
}
