package com.yunniu.farming.webadmin.service.impl;

import com.yunniu.farming.webadmin.dao.OrderSubDao;
import com.yunniu.farming.webadmin.model.OrderMain;
import com.yunniu.farming.webadmin.model.OrderSub;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class OrderSubServiceImpl {


	@Autowired
	private OrderSubDao orderSubDao;


	/**
	 * 根据id删除用户
	 *
	 * @param id主键
	 * @return
	 */
	public int deleteByid(int id) {
        int i = this.orderSubDao.deleteById(id);
        return i;
	}

	/**
	 * 按照订单主表ID查找全部数据
	 *
	 * @param id主键
	 * @return
	 */
	public OrderSub findByid(Integer id) {
		OrderSub u = this.orderSubDao.selectById(id);
		return u;
	}


	/**
	 *
	 * 增加、编辑 同一个方法
	 * @return
	 */
	public OrderSub add(OrderSub item) {

		// 1. 判断id是否为空，如果为空则直接插入，否则更新
		if (item.getId() == null) {
			this.orderSubDao.insert(item);
		}else {
			this.orderSubDao.updateById(item);
		}

		return item;
	}


	/**
	 * @更新
	 * @return
	 */
	public int update(OrderSub doc) {
		if (doc.getId() == null) return -1;
		return this.orderSubDao.updateById(doc);
	}



	/**
	 * 分页查询所有数据
	 * @return
	 */
	public List<OrderSub> selectSubByParamPageList(OrderSub sub) {

		return this.orderSubDao.selectByPageList(sub);

	}

}
