package com.yunniu.farming.webadmin.service.impl;

import com.yunniu.farming.result.Result;
import com.yunniu.farming.util.DateTools;
import com.yunniu.farming.webadmin.dao.*;
import com.yunniu.farming.webadmin.model.Integralrec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class IntegralrecServiceImpl {
	
	@Autowired
	private IntegralrecDao integralrecDao;
	
	@Autowired
	private CustomerDao customerDao;
	
	
	//-------------------增、删、改、查 方法---------------------
	/**
	 * 增加、编辑 同一个方法
	 * @param user
	 * @return
	 */
	public Result add(Integralrec item){
		//1. 判断id是否为空，如果为空则直接插入，否则更新
		if(item.getId() == null){
			// 创建日期
			item.setSoprdate(DateTools.getDate("yyyy-MM-dd"));
			// 创建时间
			item.setToprtime(new Date());
			//增量保存
			this.integralrecDao.insertSelective(item);	

		}else{
			//id 为空，则调用 更新方法
			this.integralrecDao.updateByPrimaryKeySelective(item);
			
		}
		
		return Result.success(item);
	}
	

	/**
	 * 根据id查找对象
	 * @param id主键
	 * @return
	 */
	public Integralrec findByid(int id){
		Integralrec u = this.integralrecDao.selectByPrimaryKey(id);
		return u;
	}
	
	/**
	 * 根据id删除用户
	 * @param userid
	 * @return
	 */
	public int deleteByid(int id){
		int deleteR = this.integralrecDao.deleteByPrimaryKey(id);
		return deleteR;
	}

	
   /**
	 * 更新 方法
	 * @param JavaObject
	 * @return
	 */
	public int update(Integralrec item){
		if(item.getId() == null) return -1;
		
		return this.integralrecDao.updateByPrimaryKeySelective(item);
	}
	
	/**
	 * 根据 多参数 查找对象集合
	 * @param JavaObject
	 * @return
	 */
	public List<Integralrec> findByParam(Integralrec item){
		List<Integralrec> items = this.integralrecDao.selectByParam(item);
		return items;
	}
	
	/**
	 * 根据 多参数  分页查找对象集合
	 * @return
	 */
	public List<Integralrec> findByParamPageList(Integralrec main){
		return this.integralrecDao.selectByParamPageList(main);
	}
	
	//-------------------其他方法---------------------
	


	

	
	/**
	 *计算用户现在拥有的积分 
	 */
	public Double sumIntegral(Integralrec item) {

		return this.integralrecDao.sumIntegral(item);

	}
	


}

