package com.yunniu.farming.webadmin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.dao.*;
import com.yunniu.farming.webadmin.model.*;
import com.yunniu.farming.webadmin.service.GroupBuyService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.List;

/**
 * @author zyf
 * @date 2023/5/12
 * @apiNote
 */
@Slf4j
@Service
public class GroupBuyServiceimpl implements GroupBuyService {

    @Autowired
    private GroupBuyDao mapper;
    @Autowired
    private GroupBuyProductDao groupBuyProductDao;
    @Autowired
    private GroupAreaDao areaDao;
    @Autowired
    private ProductDao productDao;
    @Autowired
    private DocCatalogDao docCatalogDao;

    /**
     * 分页查询
     *
     * @return
     */
    @Override
    public List<GroupBuy> findPageList(GroupBuy item) {
        List<GroupBuy> groupBuys = mapper.findPageList(item);
        return groupBuys;
    }

    /**
     * 新增/编辑活动
     *
     * @param item
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Result addOrEdit(GroupBuy item) {
        // 判断是否为新增
        if (ObjectUtils.isEmpty(item.getId())) {
            // 设置小区id集合的值
            item.setAreaIds(JSON.toJSONString(item.getAreaIdList()));
            item.setGroupStatus(2);

            // 保存活动基础信息
            this.mapper.insert(item);
            // 判断活动商品是否有值
            if (CollectionUtils.isNotEmpty(item.getProducts())) {
                // 保存活动商品
                groupBuyProductDao.insertBath(item.getProducts(), item.getId());
            }
            return Result.success();
        } else {
            this.mapper.updateEndTime(item);
            return Result.success();
        }

    }

    /**
     * 详情
     *
     * @param id 团购id
     * @return
     */
    @Override
    public GroupBuy findById(Long id) {
        // 团购基础信息
        GroupBuy groupBuy = this.mapper.selectById(id);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        groupBuy.setStartDate(formatter.format(groupBuy.getStartTime()));
        groupBuy.setEndDate(formatter.format(groupBuy.getEndTime()));
        // 团购商品
        List<Product> productList = groupBuyProductDao.getProductList(id);
        List<GroupBuyProduct> products = groupBuyProductDao.getList(id);
//        List<GroupBuyProduct> products = groupBuyProductDao.selectList(Wrappers.<GroupBuyProduct>lambdaQuery().eq(GroupBuyProduct::getGroupBuyId, id));
        groupBuy.setProductList(JSON.toJSONString(productList));
        groupBuy.setProducts(products);
        // 团购小区
        String areaIds = groupBuy.getAreaIds();
        if (StringUtils.isNotEmpty(areaIds)) {
            List<Integer> areaIdList = JSON.parseArray(areaIds, Integer.class);
            if (CollectionUtils.isNotEmpty(areaIdList)) {
                List<GroupArea> groupAreas = areaDao.selectList(Wrappers.<GroupArea>lambdaQuery()
                        .in(GroupArea::getId, areaIdList)
                        .eq(GroupArea::getAreaStatus, 0));
                groupBuy.setAreas(groupAreas);
                groupBuy.setAreaIdList(areaIdList);
            }
        }
        return groupBuy;
    }

    /**
     * 分页查询商品列表
     *
     * @param item
     * @return
     */
    @Override
    public List<Product> productList(Product item) {
        DocCatalog catalog = docCatalogDao.selectOne(Wrappers.<DocCatalog>lambdaQuery().like(DocCatalog::getSname, "团购"));
        item.setCatalogid(catalog.getId());
        item.setIstatus(1);
        return productDao.selectByParamPageList(item);
    }

    /**
     * 根据id删除
     * @param id
     * @return
     */
    @Override
    public int delById(Long id) {
        return mapper.updateStatus(id);
    }

    @Override
    public Integer findJoinNumber() {

        return mapper.findJoinNumber();
    }

    @Override
    public List<String> findavatarList() {
        return mapper.findavatarList();
    }
}
