package com.yunniu.farming.webadmin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.mysql.cj.xdevapi.Warning;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.dao.GroupAreaDao;
import com.yunniu.farming.webadmin.dao.GroupBuyDao;
import com.yunniu.farming.webadmin.model.GroupArea;
import com.yunniu.farming.webadmin.model.GroupBuy;
import com.yunniu.farming.webadmin.service.GroupAreaService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * @author zyf
 * @date 2023/5/12
 * @apiNote
 */
@Slf4j
@Service
public class GroupAreaServiceimpl implements GroupAreaService {

    @Autowired
    private GroupAreaDao mapper;
    @Autowired
    private GroupBuyDao groupBuyDao;

    /**
     * 小程序查询
     * @param item
     * @return
     */
    @Override
    public List<GroupArea> findPageList(GroupArea item) {
        GroupBuy groupBuy = groupBuyDao.selectById(item.getGroupBuyId());
        if (StringUtils.isNotEmpty(groupBuy.getAreaIds())) {
            List<Integer> areaids = JSON.parseArray(groupBuy.getAreaIds(), Integer.class);
            item.setAreaIds(areaids);
        }
        return mapper.findPageList(item);
    }

    /**
     * 添加团购小区
     * @param item
     * @return
     */
    @Override
    public Result addOrEdit(GroupArea item) {
        if (item.getId() == null) {
            return Result.success(this.mapper.insert(item));
        }else {
            return Result.success(this.mapper.updateById(item));
        }
    }

    @Override
    public Result delete(Integer id) {

        return Result.success(this.mapper.deleteArea(id));
    }

    /**
     * 后管分页查询
     * @param item
     * @return
     */
    @Override
    public List<GroupArea> getPageList(GroupArea item) {
        return mapper.findPageList(item);
    }

    @Override
    public GroupArea findById(Long areaId) {
        return mapper.selectById(areaId);
    }

    @Override
    public List<GroupArea> findList() {
        return mapper.selectList(Wrappers.<GroupArea>lambdaQuery().eq(GroupArea::getAreaStatus,0));
    }
}
