package com.yunniu.farming.webadmin.service.impl;

import com.yunniu.farming.result.Result;
import com.yunniu.farming.util.*;
import com.yunniu.farming.webadmin.dao.DocCatalogDao;
import com.yunniu.farming.webadmin.dao.ProductDao;
import com.yunniu.farming.webadmin.model.Banner;
import com.yunniu.farming.webadmin.model.DocCatalog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@Service
public class DocCatalogServiceImpl {
	@Autowired
	private DocCatalogDao catalogMapper;

	@Autowired
	private ProductDao productMapper;

	
	
	/**
	 *  带参 常规查询
	 */
	public List<DocCatalog> findByParam(DocCatalog doc) {

		return this.catalogMapper.selectByParam(doc);
		
	}


	/**
	 * 根据id查找对象
	 * 
	 * @param id主键
	 * @return
	 */
	public DocCatalog findById(int id) {

		return this.catalogMapper.selectByPrimaryKey(id);

	}

	/**
	 * 根据id删除
	 */
	public Result deleteById(int id) {

		int deleteDoc = this.catalogMapper.deleteByPrimaryKey(id);

		if (deleteDoc > 0){
			return Result.success(deleteDoc);
		}else  {
			return Result.error();
		}



	}


	/**
	 * 查询商品分类 带商品
	 */
	public Result selectProSubByParam(DocCatalog catalog){

        List<DocCatalog> proSubs = this.catalogMapper.selectProSubByParam(catalog);

        return Result.success(proSubs);

    }



	public Result updateGoodsClass(DocCatalog goodsClass) {
		MultipartFile goodsClassImg1 = goodsClass.getFile1();
		MultipartFile goodsClassImg2 = goodsClass.getFile2();

		if (goodsClassImg1 != null && !goodsClassImg1.isEmpty()) {
			String realpath = FileUtil.saveFile(goodsClassImg1, "house");
			String url = COSUtil.uploadFileByPath(realpath);
			if (url != null && !"".equals(url)) {
				goodsClass.setSicon(url);
			}
		}

		if (goodsClassImg2 != null && !goodsClassImg2.isEmpty()) {
			String spath = FileUtil.saveFile(goodsClassImg2, "house");
			String spathurl = COSUtil.uploadFileByPath(spath);
			if (spathurl != null && !"".equals(spathurl)) {
				goodsClass.setSpath(spathurl);
			}
		}

		if (goodsClass.getId() == null || goodsClass.getId().equals("")) {

			goodsClass.setItype(DocCatalog.TYPE_PRO);

			Integer res = catalogMapper.insert(goodsClass);
			if (res > 0) {
				return Result.success("新增成功");
			}
			return new Result(103);
		} else {
			Integer res = catalogMapper.updateById(goodsClass);
			if (res > 0) {

				return Result.success("更新成功");
			}
			return Result.error("失败");
		}
	}






	public Result updateBanner(Banner banner) {
		Banner oldBanner = catalogMapper.getBanner();
		String[] picArr = banner.getImgArr();
		String pics = "";
		if (picArr.length > 0) {
			for (int i = 0; i < picArr.length; i++) {
				if (picArr[i].startsWith("data:image")) {
					String suffix = picArr[i].substring(picArr[i].indexOf("/") + 1, picArr[i].indexOf(";"));
					String realpath = FileUtil.BasePath + "/goods/" + UUIDUtils.getUUID() + "." + suffix;
					if (ImageUtil.GenerateImage(picArr[i + 1], realpath)) {
						String url = OssUtil.uploadToOss(realpath);
//                        FileUtil.deleteFilesByRealPath(realpath);
						if ("".equals(pics)) {
							pics = url;
						} else {
							pics = pics + "," + url;
						}
					} else {
						return new Result().error("图片存储出错!");
					}
				} else if (picArr[i].startsWith("http")) {
					picArr[i] = picArr[i].replace("amp;", "");
					if ("".equals(pics)) {
						pics = picArr[i];
					} else {
						pics = pics + "," + picArr[i];
					}

				}
			}
		}
		banner.setBannerUrls(pics);
		int res = catalogMapper.updateBanner(banner);
		if (res > 0) {
			//删除oss图片
			String[] oldArr = oldBanner.getBannerUrls().split(",");
			String[] newArr = banner.getBannerUrls().split(",");
			for (int i = 0; i < oldArr.length; i++) {
				boolean b = true;
				String imgName = OssUtil.getName(oldArr[i]);
				for (int j = 0; j < newArr.length; j++) {
					if (newArr[j].indexOf(imgName) > -1) {
						b = false;
					}
				}
				if (b) {
					System.out.println("删除图片" + oldArr[i]);
					OssUtil.delOssImg(imgName);
				}
			}
			return new Result("轮播图更新成功");
		}
		return new Result().error();
	}


	public Banner getBanner() {
		return catalogMapper.getBanner();
	}

}
