package com.yunniu.farming.webadmin.service.impl;

import com.yunniu.farming.result.Result;
import com.yunniu.farming.util.*;
import com.yunniu.farming.webadmin.dao.CustomerDao;
import com.yunniu.farming.webadmin.dao.IntegralrecDao;
import com.yunniu.farming.webadmin.model.Customer;
import com.yunniu.farming.webadmin.model.Integralrec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;


@Service
public class CustomerServiceImpl {


	@Autowired
	private CustomerDao customerDao;

	@Autowired
	private IntegralrecDao integralrecDao;

    /**
     * 用户注册
     */
    public Result regist(Customer item){


        if(StringHelper.isEmpty(item.getSaccount()) || StringHelper.isEmpty(item.getSpassword())) {
            return Result.error("账号或密码为空");
        }


        //1.1 插入前判断 "账号" 是否存在
        if(checkAccountIsexisted(item.getSaccount())){
            return Result.error("账号已被注册！");
        }

        //1.2初始化 默认值
        item.setIroleid(Customer.ROLE_NORMAL);//默认 普通用户
        item.setSwxnick(item.getSaccount());
        item.setTcreatetime(new Date());//注册时间
        item.setSpassword(MD5Util.MD5Encode((MD5Util.MD5Encode(item.getSpassword(),"utf-8")).substring(16),"utf-8"));//密码加密

        //1.3 增量保存
        this.customerDao.insert(item);

        return Result.success("注册成功");

    }


    /**
     * 判断账号是否存在
     * @param account
     * @return
     */
    protected boolean checkAccountIsexisted(String account){

        if(StringHelper.isEmpty(account)) return true;
        //校验账号是否已经被注册
        Customer user = new Customer();
        user.setSaccount(account);

        List<Customer> docs = this.customerDao.selectByParam(user);
        if(docs.size() > 0) return true;

        return false;
    }


	/**
	 * APP端登录
	 */
	public Result appLogin(Customer item){

        if(StringHelper.isEmpty(item.getSaccount()) || StringHelper.isEmpty(item.getSpassword())) {
            return Result.error("账号或密码为空");
        }

        //首次加密
        String password = MD5Util.MD5Encode(item.getSpassword(), "utf-8");
        // 进行二级加密
        item.setSpassword(MD5Util.MD5Encode(password.substring(16),"utf-8"));

		List<Customer> users = this.customerDao.selectByParam(item);

		if(users==null  ||  users.size()==0) {
			return Result.error("账号或密码错误");
		}


		//将查询到的用户信息封装后返回
		Customer userback = users.get(0);


        if(userback == null) {
            return Result.error("用户不存在或已删除");
        }

		if(!userback.getSaccount().equals(item.getSaccount())){
            return Result.error("账号或密码错误");
        }

        if(!userback.getSpassword().equals(item.getSpassword())){
            return Result.error("账号或密码错误");
        }


        // 将登录密码 置空
        userback.setSpassword(null);

		return Result.success("登录成功",userback);
	}





    /**
     * 修改密码
     *
     * @param saccount
     * @param oldPassword
     * @param newPassword
     * @return
     */
    public Result modifyPassword(Customer item) {

        Customer customer = new Customer();
        customer.setSaccount(item.getSaccount());
        List<Customer> users = this.customerDao.selectByParam(customer);

        if(users==null  ||  users.size()==0) {
            return Result.error("账号不存在");
        }

        //将查询到的用户信息封装后返回
        Customer userback = users.get(0);

        if(userback == null) {
            return Result.error("账号不存在");
        }


        Customer user = new Customer();

        user.setId(userback.getId());
        //首次加密
        String password = MD5Util.MD5Encode(item.getSpassword(), "utf-8");
        // 进行二级加密
        user.setSpassword(MD5Util.MD5Encode(password.substring(16),"utf-8"));

        this.customerDao.updateById(user);


        return Result.success("修改成功",user);

    }




	/**
	 * 分页查询所有数据
	 * @return
	 */
	public List<Customer> selectByParamPageList(Customer doc) {
		return this.customerDao.selectByParamPageList(doc);

	}


	/**
	 * 分页查询所有数据
	 * @return
	 */
	public List<Customer> selectCountByParamPageList(Customer doc) {
		return this.customerDao.selectCountByParamPageList(doc);

	}


	/**
	 * FRICE TODO 带参 常规查询
	 *
	 * @return
	 */
	public List<Customer> findByParam(Customer doc) {
		List<Customer> uList = this.customerDao.selectByParam(doc);
		return uList;

	}

	/**
	 * 根据id删除用户
	 *
	 * @param id主键
	 * @return
	 */
	public int deleteByid(int id) {
        int i = this.customerDao.deleteById(id);
        return i;
	}

	/**
	 * 按照订单主表ID查找全部数据
	 *
	 * @param id主键
	 * @return
	 */
	public Customer findByid(Integer id) {
		Customer u = this.customerDao.selectById(id);
		return u;
	}



	/**
	 *
	 * 增加、编辑 同一个方法
	 * @return
	 */
	public Customer add(Customer item) {

		// 1. 判断id是否为空，如果为空则直接插入，否则更新
		if (item.getId() == null) {
			this.customerDao.insert(item);
		}else {
			this.customerDao.updateById(item);
		}

		return item;
	}

	/**
	 * @更新
	 * @return
	 */
	public Result update(Customer doc) {

		if (doc.getId() == null) return Result.error("修改失败");

        int i = this.customerDao.updateById(doc);

        if(i > 0){

            return Result.success("修改成功",doc);

        }else {

            return Result.error("修改失败");

        }

    }





	//增加用户积分
	public Result addIntegral(Customer item) {

		if(item.getId() == null || item.getId().equals("")){
			return Result.error("用户信息为空");
		}

		if(item.getDincome() == null || item.getDincome() <= 0){
			return Result.error("积分不能为空");
		}

		Integralrec inte = new Integralrec();
		inte.setDincome(item.getDincome());
		inte.setCustomerid(item.getId());
		inte.setItype(Integralrec.INTEGRALREC_ADMIN);//系统赠送
		inte.setSdesc("系统赠送");
		inte.setSoprdate(DateTools.getDate("yyyy-MM-dd"));
		inte.setToprtime(new Date());
		integralrecDao.insertSelective(inte);


		return Result.success();
	}




}
