package com.yunniu.farming.webadmin.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.util.COSUtil;
import com.yunniu.farming.util.FileUtil;
import com.yunniu.farming.util.ImageUtil;
import com.yunniu.farming.util.UUIDUtils;
import com.yunniu.farming.webadmin.dao.BannerDao;
import com.yunniu.farming.webadmin.model.Banner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@Service
public class BannerServiceImpl {

	@Autowired
	private BannerDao mapper;


	/**
	 * 分页查询
	 * @param item
	 * @return
	 */
	public List<Banner> findPageList(Banner item){
		//调用service 方法 返回查询结果集
		return this.mapper.findPageList(item);
	}

	/**
	 * 普通带参查询
	 * @param doc
	 * @return
	 */
	 public Result findByParam(){
		 List<Banner> banners = this.mapper.selectList(Wrappers.<Banner>lambdaQuery().eq(Banner::getBannerStatus, 0));
         return Result.success(banners);
	 }



    public Banner findById(Integer id) {
		return this.mapper.selectById(id);
    }


    public Result deleteByid(int id){
        int deleteR = this.mapper.deleteById(id);
        if (deleteR > 0) {
            return Result.success("删除成功");
        }
        return Result.error();
    }



	/**
	 *
	 * 增加、编辑 同一个方法
	 * @return
	 */
	public Result add(Banner item) {

		String[] picArr = item.getImgArr();
		String pics = "";
		if (picArr.length > 0) {
			for (int i = 0; i < picArr.length; i++) {
				if (picArr[i].startsWith("data:image")) {
					String suffix = picArr[i].substring(picArr[i].indexOf("/") + 1, picArr[i].indexOf(";"));
					String realpath = FileUtil.BasePath + "/goods/" + UUIDUtils.getUUID() + "." + suffix;
					if (ImageUtil.GenerateImage(picArr[i + 1], realpath)) {
						String url = COSUtil.uploadFileByPath(realpath);
						FileUtil.deleteFilesByRealPath(realpath);
						if ("".equals(pics)) {
							pics = url;
						} else {
							pics = pics + "," + url;
						}
					} else {
						return new Result().error("图片存储出错!");
					}
				} else if (picArr[i].startsWith("http")) {
					picArr[i] = picArr[i].replace("amp;", "");
					if ("".equals(pics)) {
						pics = picArr[i];
					} else {
						pics = pics + "," + picArr[i];
					}
				}
			}
		}else {
			return Result.error("图片不能为空！");
		}
		if (pics.indexOf(",") > -1) {
			item.setBannerUrls(pics.substring(0, pics.indexOf(",")));
		} else {
			item.setBannerUrls(pics);
		}

		MultipartFile goodsClassImg = item.getFile1();
		if (goodsClassImg != null && !goodsClassImg.isEmpty()) {
			String realpath = FileUtil.saveFile(goodsClassImg, "house");
			String url = COSUtil.uploadFileByPath(realpath);
			if (url != null && !"".equals(url)) {
				item.setPathUrls(url);
			}
		}

		// 1. 判断id是否为空，如果为空则直接插入，否则更新
		if (item.getBannerId() == null|| item.getBannerId().equals("")) {

			item.setBannerId(null);

			this.mapper.insert(item);

		}else {


			this.mapper.updateById(item);

		}

		return Result.success("添加成功");
	}


}
