package com.yunniu.farming.webadmin.service.impl;


import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.dao.AccountalterrecDao;
import com.yunniu.farming.webadmin.dao.ArticleDao;
import com.yunniu.farming.webadmin.model.Article;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class ArticleServiceImpl {
	
	@Autowired
	private ArticleDao mapper;

	@Autowired
	private AccountalterrecDao AccountalterrecDao;


	
	/**
	 * 增加编辑同一个方法
	 * @param item
	 * @return
	 */
	public Result insertSelective(Article item){
		// 1. 判断id是否为空，如果为空则直接插入，否则更新
		if (item.getId() == null) {
			Date date = new Date();
			item.setTcreatetime(date);
			//1.3 增量保存
			this.mapper.insertSelective(item);
		} else {
			// 2. id 不为空，则调用 更新方法
			this.mapper.updateByPrimaryKeySelective(item);
		}
		return Result.success(item);
	}





	/**
	 * 增加意见反馈
	 */
	public Result saveIdea(Article item){

		item.setItype(20);

		item.setTcreatetime(new Date());

		//1.3 增量保存
        int i = this.mapper.insertSelective(item);

        if (i > 0){
            return Result.success("添加成功",item);
        }else {
            return Result.error("添加失败");
        }


	}


	/**
	 * 根据 多参数来统计 累计数量
	 * @return
	 */
	public int findAdminCount(Article main){
		return this.mapper.findAdminCount(main);
	}

	/**
	 * 删除
	 * @param id
	 * @return
	 */
	public int deleteByid(Integer id){
		int deleteDoc = this.mapper.deleteByid(id);
		return deleteDoc;
	}

	/**
	 * 分页查询 
	 * @param item
	 * @return
	 */
	public List<Article> findPageList(Article item){
		return this.mapper.findPageList(item);
	}
	
	/**
	 * 普通带参查询
	 */
	 public Result findByParam(Article doc){

         List<Article> byParam = this.mapper.findByParam(doc);

         return Result.success(byParam);
	 }


	/**
	 * 带参查询 是否阅读
	 */
	public Result findParamRead(Article doc){
		List<Article> ac = this.mapper.findParamRead(doc);
		return Result.success(ac);
	}



	public Article findByid(Integer id) {
		Article article = this.mapper.selectByPrimaryKey(id);
		return article;
	}


	
}
