package com.yunniu.farming.webadmin.service.impl;

import com.yunniu.farming.common.plugin.PageInfo;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.dao.AddressDao;
import com.yunniu.farming.webadmin.model.Address;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Service
public class AddressServiceImpl {

	
	@Autowired
	private AddressDao addressDao;

	//-------------------增、删、改、查 方法---------------------
	/**
	 * 增加、编辑 同一个方法
	 */
	public Result add(Address item){

		//判断id是否为空，如果为空则直接插入，否则更新
		if(item.getId() == null){

			this.addressDao.insert(item);
		
		}else{

			this.addressDao.updateById(item);

		}

		//更新默认地址，若当前地址为默认，则更新其他地址为非默认
		if(item.getId() != null && item.getIsdefault() == Address.FLAG_Y) {
			this.addressDao.updateDefault(item);
		}
		
		return Result.success(item);
	}


	/**
	 * 更新 方法
	 */
	public Result update(Address item){

		if(item.getId() == null) return Result.error("id为空");

		int i = this.addressDao.updateById(item);

		if(i > 0){
			return Result.success("更新成功");
		}else {
			return Result.error();
		}

	}




	/**
	 * 根据id查找对象
	 */
	public Address findByid(int id){
		return this.addressDao.selectByPrimaryKey(id);
	}

	/**
	 * 根据id删除用户
	 */
	public Result deleteByid(int id){
		int deleteR = this.addressDao.deleteByPrimaryKey(id);
		if (deleteR > 0) {
			return Result.success("删除成功");
		}
		return Result.error();
	}

	/**
	 * 根据 多参数 查找对象集合
	 */
	public Result findByParam(Address item){
		List<Address> items = this.addressDao.selectByParam(item);
		return Result.success(items);
	}


	/**
	 * 分页加多条件
	 */
	public Result findPageList(Address address){
		//这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
		Map<String,Object> rmap = new HashMap<String,Object>();
		PageInfo pageinfo = new PageInfo();
		pageinfo.setCurPage(address.getCurpage());
		pageinfo.setPageSize(address.getPagesize());
		address.setPageinfo(pageinfo);
		// 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
		PageInfo pinfo = address.getPageinfo();
		if(pinfo == null) {
			pinfo = new PageInfo();
			address.setPageinfo(pinfo);
		}else{
			// 分页开始记录数
			int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
			pinfo.setCurRecord(curRecord);
			address.setPageinfo(pinfo);
		}

		// 2.1 执行主表 查询
		List<Address> items = this.addressDao.selectByParamPageList(address);
		// 3.将查询结果的 分页数据封装后返回
		int totalRs = pinfo.getTotalRecords();		//总记录数
		int totalPs = 0;					  		//总页数
		if(totalRs % pinfo.getPageSize() == 0){		//总页数计算
			totalPs = totalRs / pinfo.getPageSize() ;
		}else{
			totalPs = 1 + totalRs / pinfo.getPageSize() ;
		}
		pinfo.setTotalPages(totalPs);

		// 4.将分页对象、结果集合 封装后返回前台
		rmap.put("pageinfo", pinfo);
		rmap.put("items", items);

		return Result.success(rmap);

	}
}
