package com.yunniu.farming.webadmin.service.impl;


import com.yunniu.farming.config.ReturnResult;
import com.yunniu.farming.webadmin.dao.AccountalterrecDao;
import com.yunniu.farming.webadmin.dao.CustomerDao;
import com.yunniu.farming.webadmin.model.Accountalterrec;
import com.yunniu.farming.webadmin.model.Customer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @功能  收益管理
 * @author
 *
 */
@Service
public class AccountalterrecServiceImpl {

	@Autowired
	private AccountalterrecDao accountalterrecDao;

	@Autowired
	private CustomerDao customerDao;

	/**
	 * @增加编辑同一个方法
	 * @param item
	 * @return
	 */
	public ReturnResult add(Accountalterrec item){

		// 1. 判断id是否为空，如果为空则直接插入，否则更新
		if (item.getId() == null) {

			//存入当前的系统时间，getDatetime获取字符串的当前时间  getDateByStr将字符串转换成Date类型
			item.setTcreatetime(new Date());

			//1.3 增量保存
			this.accountalterrecDao.insertSelective(item);

		} else {

			// 2. id 不为空，则调用 更新方法
			this.accountalterrecDao.updateByPrimaryKeySelective(item);
		}

		return ReturnResult.getSuccessResult(item);
	}




	/**
	 * 更新 方法
	 *
	 * @param item
	 * @return
	 */
	public int update(Accountalterrec item) {
		if (item.getId() == null)
			return -1;

		return this.accountalterrecDao.updateByPrimaryKeySelective(item);
	}

	/**
	 * @删除记录
	 * @param id
	 * @return
	 */
	public int deleteById(Integer id){
		int deleteDoc = this.accountalterrecDao.deleteByPrimaryKey(id);
		return deleteDoc;
	}


	/**
	 * @分页查询
	 * @param item
	 * @return
	 */
	public List<Accountalterrec> findPageList(Accountalterrec item){
		return this.accountalterrecDao.selectByParamPageList(item);
	}


	/**
	 * 带参 常规查询
	 */
	public List<Accountalterrec> findByParam(Accountalterrec docOpenarea) {
		List<Accountalterrec> Accountalterrecs = this.accountalterrecDao.selectByParam(docOpenarea);
		return Accountalterrecs;

	}


	/**
	 * @根据对象id进行单个查询
	 * @param id = 对象id
	 * @return
	 */
	public Accountalterrec findById(Integer id){
		return this.accountalterrecDao.selectByPrimaryKey(id);
	}


	/**
	 * @根据对象id查询余额
	 * @param doc = 对象id
	 * @return
	 */
	public ReturnResult findBalanceByid(Accountalterrec doc){

	    if(doc.getCustomerid() == null){
	        return ReturnResult.getErrorResult("参数不能为空");
        }
        Accountalterrec accountalterrec = this.accountalterrecDao.selectBalanceByid(doc);

        return ReturnResult.getSuccessResult(accountalterrec);
	}



	/**
	 * @用户提现申请
	 */
	public ReturnResult toAuditWithDraw(Accountalterrec item){

		if(item.getIcashtype() == null){
			return ReturnResult.getErrorResult("非法提现");
		}


		if(item.getIcashtype() == 10){ //业绩提现
			if (item.getDrmbout() == null || item.getDrmbout() <= 0) {
				return ReturnResult.getErrorResult("非法提现金额");
			}
		} else if (item.getIcashtype() == 20){ //津贴提现
			if (item.getDcoinout() == null || item.getDcoinout() <= 0) {
				return ReturnResult.getErrorResult("非法提现金额");
			}
		}else {
			return ReturnResult.getErrorResult("非法提现");
		}


		if(item.getCustomerid() == null){
			return ReturnResult.getErrorResult("账户不存在或已删除");
		}

		// 根据用户id 查找 用户信息
		Customer user = this.customerDao.selectByPrimaryKey(item.getCustomerid());
		if(user == null){
			return ReturnResult.getErrorResult("账户不存在或已删除");
		}


		//校验账户余额 是否够用
		Accountalterrec cr = new Accountalterrec();
		cr.setCustomerid(item.getCustomerid());
		//可提现余额
		Accountalterrec curB = this.accountalterrecDao.selectBalanceByid(cr);


		//业绩提现
		if(item.getIcashtype() == 10){
			//  提现金额 是否小于 可提现金额，如果 可提现金额不足，则直接 返回错误提示
			if (curB == null || curB.getYjbalance() <= 0 || item.getDrmbout() > curB.getYjbalance()) {
				return ReturnResult.getErrorResult("可提现金额不足");
			}

			//资金记录表中 新增一条 对应的提现记录，并且 保存相应的字段值
			//提现申请时间 取系统时间
			item.setTcreatetime(new Date());
			//提现状态 （istatus=0待审）
			item.setIstatus(Accountalterrec.STATUS_WITHDRAW_AUDIT);
			// 类型收益提现
			item.setSdesc("提现申请");//描述内容
			item.setItype(Accountalterrec.ITYPE_YJ_OUT);
			item.setIdetailtype(Accountalterrec.ITYPE_YJ_OUT_WITHDRAW);
		}

		//津贴提现
		if(item.getIcashtype() == 20){
			//  提现金额 是否小于 可提现金额，如果 可提现金额不足，则直接 返回错误提示
			if (curB == null || curB.getJtbalance() <= 0 || item.getDcoinout() > curB.getJtbalance()) {
				return ReturnResult.getErrorResult("可提现金额不足");
			}

			//资金记录表中 新增一条 对应的提现记录，并且 保存相应的字段值
			//b.提现申请时间 取系统时间
			item.setTcreatetime(new Date());
			//提现状态 （istatus=0待审
			item.setIstatus(Accountalterrec.STATUS_WITHDRAW_AUDIT);
			// 类型收益提现
			item.setSdesc("提现申请");//描述内容
			item.setItype(Accountalterrec.ITYPE_JT_OUT);
			item.setIdetailtype(Accountalterrec.ITYPE_JT_OUT_WITHDRAW);
		}

		//本地记录提现申请
		this.accountalterrecDao.insertSelective(item);

		return ReturnResult.getSuccessResult(item);

	}






	/**
	 * @提现申请 审核：通过、拒绝
	 * @param item
	 */
	public ReturnResult auditWithDraw(Accountalterrec item) {

		if(item.getIstatus() == Accountalterrec.STATUS_WITHDRAW_REFUSE){//提现拒绝

			//若为修改为拒绝提现，生成回退记录
			Accountalterrec acc = this.accountalterrecDao.selectByPrimaryKey(item.getId());

			//查询  目标信息
			Customer user = this.customerDao.selectByPrimaryKey(acc.getCustomerid());
			if(user == null) {
				return ReturnResult.getErrorResult("用户不存在");
			}

			//业绩提现
			if(acc.getIcashtype() == 10){
				Accountalterrec account = new Accountalterrec();
				account.setItype(Accountalterrec.ITYPE_YJ_IN);//操作分类
				account.setDrmbin(acc.getDrmbout());//回退金额
				account.setIdetailtype(Accountalterrec.ITYPE_YJ_IN_REFUSE);//类型明细[提现拒绝退回]
				account.setTcreatetime(new Date());//操作时间
				account.setSdesc("提现拒绝退回");//描述内容=>提现退回、
				account.setSreason(item.getSreason());//
				account.setCustomerid(acc.getCustomerid());//用户
				this.accountalterrecDao.insertSelective(account);
			}

			//津贴提现
			if(acc.getIcashtype() == 20){
				Accountalterrec account = new Accountalterrec();
				account.setItype(Accountalterrec.ITYPE_JT_IN);//操作分类
				account.setDrmbin(acc.getDrmbout());//回退金额
				account.setIdetailtype(Accountalterrec.ITYPE_JT_IN_REFUSE);//类型明细[提现拒绝退回]
				account.setTcreatetime(new Date());//操作时间
				account.setSdesc("提现拒绝退回");//描述内容=>提现退回、
				account.setSreason(item.getSreason());//
				account.setCustomerid(acc.getCustomerid());//用户
				this.accountalterrecDao.insertSelective(account);
			}


		}

		//审核时间
		item.setTaudittime(new Date());

		//更新当前操作记录数据
		this.accountalterrecDao.updateByPrimaryKeySelective(item);

		return ReturnResult.getSuccessResult(item);
	}


    public ReturnResult countShouYi(Accountalterrec accountalterrec) {

		if(accountalterrec.getCustomerid() == null){
			return  ReturnResult.getErrorResult();
		}

        Double shouYi = this.accountalterrecDao.countShouYi(accountalterrec);

        return ReturnResult.getSuccessResult(shouYi);

    }



    public ReturnResult countTeamJt(Accountalterrec accountalterrec) {

        if(accountalterrec.getCustomerid() == null){
            return  ReturnResult.getErrorResult();
        }

        Double teamJt = this.accountalterrecDao.countTeamJt(accountalterrec);

        return ReturnResult.getSuccessResult(teamJt);

    }

    public ReturnResult countManageJt(Accountalterrec accountalterrec) {

        if(accountalterrec.getCustomerid() == null){
            return  ReturnResult.getErrorResult();
        }

        Double manageJt = this.accountalterrecDao.countManageJt(accountalterrec);

        return ReturnResult.getSuccessResult(manageJt);
    }
}
