package com.yunniu.farming.webadmin.model;

import lombok.Data;

@Data
public class Result {
    private Integer code = 100;//状态码100正常,101token出错,102参数错误,103错误,104没成功,返回提示
    private String msg = "操作成功";//消息
    private Object data;//数据对象

    /**
     * 无参构造器
     */
    public Result() {
        super();
    }

    /**
     * 只返回状态,消息
     *
     * @param
     * @param
     * @param msg
     */
    public Result(String msg) {
        super();
        this.msg = msg;
    }

    /**
     * 只返回状态,消息
     * @param
     */
    public Result(Integer code) {
        super();
        this.code = code;
        if (code == 101) {
            this.msg = "验证错误,请重新登录!";
        } else if (code == 102) {
            this.msg = "参数错误!";
        } else if (code == 103) {
            this.msg = "发生错误!";
        }
    }

    /**
     * 只返回状态,消息
     * @param msg
     */
    public Result(Integer code, String msg) {
        super();
        this.code = code;
        this.msg = msg;
    }


    public Result(Object data) {
        super();
        this.data = data;
    }

    /**
     * 返回全部信息状态码，消息，数据对象
     *
     * @param
     * @param code
     * @param msg
     * @param
     */
    public Result(Integer code, String msg, Object data) {
        super();
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    /**
     * 失败
     */
    public static Result error(String msg) {
        Result rb = new Result();
        rb.setCode(103);
        rb.setMsg(msg);
        rb.setData(null);
        return rb;
    }


    /**
     * 失败
     */
    public static Result error() {
        Result rb = new Result();
        rb.setCode(103);
        rb.setMsg("发生错误");
        rb.setData(null);
        return rb;
    }

}
