package com.yunniu.farming.webadmin.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.yunniu.farming.common.plugin.PageInfo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class Product {

	//辅助对象:分页信息对象
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
	private PageInfo pageinfo;
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer curpage; // 分页页码
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer pagesize; // 分页个数


    // 辅助查询字段
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sortfields;//排序字段
    //
    // 辅助字段
    @TableField(exist = false)
    private Integer realnum;//实际销量
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String catalogName;//商品分类名称
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String mchName;//商家名
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String[] goodsImgArr;

    public static final Integer PRODUCT_TYPE = 10;//平台商品

    private Integer id;
    private String saccesstoken;
    private Integer ishot;//是否推荐 1 是  0否
    private String sname;//名称
    private String slabels;//多个标签以|隔开
    private Integer catalogid;//导航分类档案id，关联导航分类档案id
    private String ssharepic;//多图图片
    private String sshortpic;//商品首图
    private Double doldprice;//商品原价
    private Double dsaleprice;//商品售价
    private Integer itype;//商品类型[10:平台商品 20 打折商品 30积分商品]
    private Integer istatus;//'商品状态[0:待审1:上架2:拒绝3:下架]'
    private Double ddiscount;//折扣
    private Integer isalenum;//销量

    private String sfactory;//生产地
    private String spcode;//商品编码
    private String scondition;//保存条件
    private String specs;//规格
    private Integer iintanum;//积分上限
    private String sunit;//单位
    private String  sduction;//简介
    private String sdetail;//'商品详情

    private String screatedate;//创建日期
    private Date tcreatetime;//'创建时间',

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef1;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef2;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef3;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef4;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef5;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer idef6;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer idef7;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private BigDecimal ddef8;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private BigDecimal ddef9;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Date ddef10;

    @TableField(exist = false)
    private BigDecimal productPrice;
}