package com.yunniu.farming.webadmin.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.yunniu.farming.common.plugin.PageInfo;
import lombok.Data;
import org.eclipse.core.internal.runtime.Product;

import java.util.Date;

/**
 * 订单子表
 */
@Data
public class OrderSub {

	// 关联查询对象：商品信息
	@TableField(exist = false)
	private Product product;

	// 辅助对象:分页信息对象
	@TableField(exist = false)
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private PageInfo pageinfo;
	@TableField(exist = false)
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Integer curpage; // 分页页码
	@TableField(exist = false)
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Integer pagesize; // 分页个数


	//数据库字段
	private Integer id; //id主键
	private Integer mainid; //订单主表id，关联订单主表id[多对一关系]
	private Integer productid; //商品id，关联商品信息表id
	private String sproductname; // 商品名称
	private String spshortpic; // 商品图片
	private Double sgoodprice;//商品单价
	private Integer ipronum; //购买数量[整数]
	private Double dprosum; //金额小计[单位:元][两位小数]

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String sdef1; //自定义项1 退款状态 1申请退款，2申请成功，3申请拒绝，4退款成功
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String sdef2; //自定义项2 退款成功数量
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String sdef3; //自定义项3 退款申请中的数量
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String sdef4; //自定义项4
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String sdef5; //自定义项5
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Integer idef6; //自定义项6
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Integer idef7; //自定义项7
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Double ddef8; //自定义项8
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Double ddef9; //自定义项9
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Date ddef10; //自定义项10


}