package com.yunniu.farming.webadmin.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
@Data
@TableName(value = "order_refund")
public class OrderRefund implements Serializable {
    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 订单主表id
     */
    @TableField(value = "order_mian_id")
    private Long orderMianId;

    /**
     * 退款类型（1：仅退款，2退货退款）
     */
    @TableField(value = "refund_type")
    private String refundType;

    /**
     * 是否部分退（0是，1否）
     */
    @TableField(value = "portion")
    private String portion;

    /**
     * 退款编码
     */
    @TableField(value = "refund_code")
    private String refundCode;

    /**
     * 退款状态（1退款申请，2申请通过，3申请拒绝，4待退货，5退款成功,6待退款）
     */
    @TableField(value = "refund_status")
    private String refundStatus;

    /**
     * 退款金额
     */
    @TableField(value = "refund_money")
    private Double refundMoney;

    /**
     * 退款申请时间
     */
    @TableField(value = "refund_time")
    private Date refundTime;

    /**
     * 退款完成时间
     */
    @TableField(value = "refund_suc_time")
    private Date refundSucTime;
    /**
     * 退款原因
     */
    @TableField(value = "refund_reason")
    private String refundReason;

    /**
     * 退款图片
     */
    @TableField(value = "refund_img")
    private String refundImg;

    /**
     * 退款详情
     */
    @TableField(value = "refund_detail")
    private String refundDetail;

}