package com.yunniu.farming.webadmin.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.yunniu.farming.common.plugin.PageInfo;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 订单主表
 */
@Data
public class OrderMain {

    public static final Integer FLAG_Y = 1;
    public static final Integer FLAG_N = 0;


    //支付状态[0:未支付1:支付成功2:支付失败]
    public static final Integer PAY_STATUS_NO = 0;
    public static final Integer PAY_STATUS_OK = 1;
    public static final Integer PAY_STATUS_FAIL = 2;

    // 订单类型
    public static final Integer ITYPE_TAKE = 10; // 外卖订单
    public static final Integer ITYPE_GROUP = 20; // 团购订单

    // 关联查询对象: 关联用户表
    @TableField(exist = false)
    private Customer customer;
    @TableField(exist = false)
    private OrderRefund orderRefund;

    //提交订单校验错误信息
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String errormsg;

    // 关联查询对象：订单子表属性
    @TableField(exist = false)
    private List<OrderSub> subs;


    // 辅助对象:分页信息对象
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private PageInfo pageinfo;
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer curpage; // 分页页码
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer pagesize; // 分页个数

    // 辅助查询条件:开始日期、结束日期
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String beginDate;
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String endDate;

    //订单状态[10:待付款 20:待发货 30:待收货 90:已完成 99:已拒绝/关闭 100:取消 101退款申请中 102待退货 103待退款 104退款成功 105退款拒绝 106仅退款]
    public static final Integer STATUS_NOPAY = 10;
    public static final Integer STATUS_YESPAY = 20;
    public static final Integer STATUS_WAITING = 30;
    public static final Integer STATUS_COMPLETE = 90;
    public static final Integer STATUS_REFUSEED = 99;
    public static final Integer STATUS_CANCEL = 100;
    public static final Integer STATUS_APPLICATION = 101;
    public static final Integer STATUS_RETURN_GOODS = 102;
    public static final Integer STATUS_REFUND = 103;
    public static final Integer STATUS_REFUND_SUC = 104;
    public static final Integer STATUS_REFUND_REFUSE = 105;
    public static final Integer STATUS_REFUND_ONLY = 106;

    //数据库字段
    private Integer id; // id主键
    @TableField(exist = false)
    private Integer zid; // id主键
    private Integer customerid; // 客户id
    private Integer productid; // 商品id，关联商品信息表id
    private Integer addressid;//地址id，关联地址表
    private String scusaddr; // 客户地址
    private String scuname;//姓名
    private String scuphone;//电话
    private String sprovince;//省份
    private String scity;//城市
    private String sregion;	//地区
    private String sorderno; // 订单编号
    private String sorderdate; // 订单日期[yyyy-MM-dd]
    private Date tordertime; // 下单时间[yyyy-MM-dd hh:mm:ss]
    private Date tovertime; // 结束时间[yyyy-MM-dd hh:mm:ss]
    private Double dplanmoney; //订单应付金额[单位:元][两位小数]
    private Double dactmoney; // 订单实付金额[单位:元][两位小数]
    private Double dactscore; // 订单实付积分[整数]
    private Integer ipaystatus; // 支付状态[0:未支付1:支付成功2:支付失败]
    private Date tpaytime; // 支付时间[yyyy-MM-dd hh:mm:ss]
    private String refundorderno;
    private Integer irefundstatus; // 退款状态[1退款申请，2申请通过，3申请拒绝，4待退货，5退款成功,6待退款]
    @TableField(exist = false)
    private Integer irefundtype; // 退款类型[1：仅退款，2退货退款]

    private Double irefundmoney; // 退款金额
    private Date trefundtime; // 退款时间[yyyy-MM-dd hh:mm:ss]
    private String srefundreason; // 退款理由
    private String srefundpic; // 退款图片
    private String couriernumber; // 退货快递单号
    private Integer istatus; // 订单状态
    private Integer itype; // 订单类型 //10 外卖订单 20 团购订单
    private Integer ipaytype; // 支付方式[10:微信支付.20:支付宝支付.30积分支付]

    private String sremark; // 备注信息
    @TableField(exist = false)
    private String remark; // 发货备注信息



    private String sdef1; // 自定义项1 团购收货联系人
    private String sdef2; // 自定义项2 团购收获手机号
    private String sdef3; // 自定义项3 团购收货详细地址
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef4; // 自定义项4 支付回调标识
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef5; // 自定义项5 发货备注
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer idef6; // 自定义项6
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer idef7; // 自定义项7
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Double ddef8; // 自定义项8
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Double ddef9; // 自定义项9
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Date ddef10; // 自定义项10

    private Long groupOrderId;

    @TableField(exist = false)
    private Long areaId;

    @TableField(exist = false)
    private Long groupBuyId;

    @TableField(exist = false)
    private String groupBuyName;

    @TableField(exist = false)
    private Integer appflag;

    @TableField(exist = false)
    private String swxnick;

}
