package com.yunniu.farming.webadmin.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.yunniu.farming.common.plugin.PageInfo;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author zyf
 * @date 2023/5/16
 * @apiNote
 */
@Data
public class GroupOrder {

    private Long id;

    private String orderCode;

    private Long groupBuyId;

    private Long areaId;

    private Integer groupSize;

    private String groupStatus;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date successTime;
    @TableField(exist = false)
    private String successTimeStr;

    private Date createTime;

    private String createBy;

    private String remark;

    /**
     * 辅助对象:分页信息对象
     */
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private PageInfo pageinfo;

    /**
     * 分页页码
     */
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer curpage;

    /**
     *  分页个数
     */
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer pagesize;

    /**
     * 活动标题
     */
    @TableField(exist = false)
    private String groupBuyTitle;

    /**
     * 小区名称
     */
    @TableField(exist = false)
    private String areaName;

    /**
     * 订单实付金额
     */
    @TableField(exist = false)
    private BigDecimal sumDactmoney;
}
