package com.yunniu.farming.webadmin.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.yunniu.farming.common.plugin.PageInfo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author zyf
 * @date 2023/5/15
 * @apiNote
 */
@Data
public class GroupBuyProduct {

    private Long id;

    private Long groupBuyId;

    private Long productId;

    private String productPic;

    private String productName;

    private String productSduction;

    private BigDecimal productPrice;

    private String sunit;

    private Integer status;

    private Date createTime;

    private String createBy;

    private Date updateTime;

    private String updateBy;

    @TableField(exist = false)
    private Integer ipronum;

    /**
     * 辅助对象:分页信息对象
     */
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private PageInfo pageinfo;

    /**
     * 分页页码
     */
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer curpage;

    /**
     *  分页个数
     */
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer pagesize;
}
