package com.yunniu.farming.webadmin.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.yunniu.farming.common.plugin.PageInfo;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author zyf
 * @date 2023/5/12
 * @apiNote
 */
@Data
public class GroupBuy {

    /**
     * 主见id
     */
    private Long id;

    /**
     * 团购编码
     */
    private String groupBuyCode;

    /**
     * 团购标题
     */
    private String groupBuyTitle;

    /**
     * 团购图片
     */
    private String groupBuyPic;

    /**
     * 简介
     */
    private String groupBlurb;

    /**
     * 拼团开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    @TableField(exist = false)
    private String startDate;

    /**
     * 拼团结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;
    @TableField(exist = false)
    private String endDate;


    /**
     * 团购状态：1 待发布，2待生效，3已生效，4已结束，5已删除
     */
    private Integer groupStatus;

    /**
     * 成团人数
     */
    private Integer groupSize;

    /**
     * 小区id 集合
     */
    private String areaIds;
    @TableField(exist = false)
    private List<Integer> areaIdList;

    /**
     * 详情
     */
    private String groupDetail;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人
     */
    private String  createBy;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 修改人
     */
    private String updateBy;

    /**
     * 辅助对象:分页信息对象
     */
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private PageInfo pageinfo;

    /**
     * 分页页码
     */
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer curpage;

    /**
     *  分页个数
     */
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer pagesize;

    @TableField(exist = false)
    private List<GroupBuyProduct> products;

    @TableField(exist = false)
    private String productList;

    @TableField(exist = false)
    private List<GroupArea> areas;

    @TableField(exist = false)
    private Integer appFlag;

    @TableField(exist = false)
    private BigDecimal minPrice;

    @TableField(exist = false)
    private BigDecimal maxprice;

    @TableField(exist = false)
    private String startAndEndTime;

    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String[] goodsImgArr;

}
