package com.yunniu.farming.webadmin.model;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 分类管理
 */
@Data
public class DocCatalog implements Serializable {

	public static final Integer FLAG_N = 0; //否
	public static final Integer FLAG_Y = 1;	//是

	//分类类型:[10:商品分类]
	public static final Integer TYPE_PRO = 10;

    @TableField(exist = false)
    private List<Product> prosubs;

    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private MultipartFile file1;

    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private MultipartFile file2;

	
    private Integer id;//H:id主键
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String saccesstoken;//B:小程序端token
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer sysadminid;//B:所属系统管理员id
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer mchid;//B:商家id
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer productid;//B:商品id
    private Integer itype;//H:分类类型[10:商品分类]
    private String sname;//FI:分类名称
    private String sicon;//FI:导航分类图片存储路径
    private String spath;//FI:介绍图片
    private String sdesc;//FI:分类介绍
    private Integer ilevel;//B:树形结构级别[1级、2级...]
    private Integer parentid;//B:上一级分类id[树形结构]
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer iablepubinfo;//FR:是否可以在此类发布信息[0:否1:是]
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer isshow;//FR:是否显示[0:不显示1:显示]
    private Integer isortno;//FN:排序序号
    private Date tcreatetime; // 下单时间[yyyy-MM-dd hh:mm:ss]
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef1;//自定义项1
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef2;//自定义项2
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef3;//自定义项3
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef4;//自定义项4
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef5;//自定义项5
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer idef6;//自定义项6
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer idef7;//自定义项7
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private BigDecimal ddef8;//自定义项8
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private BigDecimal ddef9;//自定义项9
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Date ddef10;//自定义项10

}