package com.yunniu.farming.webadmin.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.yunniu.farming.common.plugin.PageInfo;
import lombok.Data;


import java.math.BigDecimal;
import java.util.Date;
/**
 * 用户表
 */
@Data
public class Customer {

	//是否[0:否1:是]
	public static final Integer FLAG_N = 0; //否
	public static final Integer FLAG_Y = 1;	//是
	
	public static final Integer SEX_MALE = 1;	//性别：男
	public static final Integer SEX_FEMALE = 2; //性别：女
	public static final Integer SEX_UNKNOW = 3; //性别：未知
	
	//[10:普通用户20:会员]
	public static final Integer ROLE_NORMAL = 10; // 普通用户
	public static final Integer ROLE_CHARGE = 20; // 会员

    //会员天数  默认一年 365天
    public static final Integer VIP_DAY = 365;
    //单次天数  默认1天
    public static final Integer ONE_DAY = 1;

    //辅助字段：开始注册日期、结束注册日期
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String beginDate;
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String endDate;

	//辅助对象:分页信息对象
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
	private PageInfo pageinfo;
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer curpage; // 分页页码
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer pagesize; // 分页个数


    //短信验证码
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String msgvalidcode;
    //短信验证码的id，是加过密的，需要将此值解密转换成id值，最后通过id去验证码表中读取真正的验证码
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String idfycode;

    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Double dincome;  //积分

    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Double integral; // 积分余额


    private Integer id;
    private Integer isex;//性别[1:男2:女3:未知]
    private String sprovince;//省
    private String scity;//市
    private String sregion;//区
    private Integer iscomplete;//新用户是否
    private Integer ilevel;//会员等级[10:初级 20:中级 30::高级]
    private Date tcreatetime;//注册时间
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String saccount;//账号或 短信账号
    private String sxcxopenid;//小程序openid
    private String swxnick;//微信昵称
    private String swximgurl;//微信头像
    private Integer iroleid;//角色[10:普通用户 20:会员]
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String spassword;//真实姓名
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String senddate;//会员到期日期
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Date soverdate;//单次试用日期
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sphone;//电话

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef1;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef2;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef3;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef4;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef5;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer idef6;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer idef7;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private BigDecimal ddef8;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private BigDecimal ddef9;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Date ddef10;


}