package com.yunniu.farming.webadmin.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.yunniu.farming.common.plugin.PageInfo;
import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

@Data
public class Banner {

    // 辅助对象:分页信息对象
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private PageInfo pageinfo;
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer curpage; // 分页页码
    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer pagesize; //分页个数

    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private MultipartFile file1;

    @TableId("banner_id")
    private String bannerId;

    private String bannerUrls;

    private Integer productid;//商品id

    private Integer catalogid;//分类id

    private String pathUrls;//链接图片

    private Integer bannerStatus = 0;//状态 0启用，1停用

    @TableField(exist = false)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String[] imgArr;


}
