package com.yunniu.farming.webadmin.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.yunniu.farming.common.plugin.PageInfo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 常用地址
 * @author samsung
 *
 */
@Data
public class Address {


	public static final Integer FLAG_N = 0; //否
	public static final Integer FLAG_Y = 1;	//是
	
	// 辅助对象
	@TableField(exist = false)
	private PageInfo pageinfo;//分页信息对象
	@TableField(exist = false)
	private Integer curpage; // 分页页码
	@TableField(exist = false)
	private Integer pagesize; // 分页个数

	//一对一查询
	@TableField(exist = false)
	private Customer customer;//对应客户信息


	//数据库字段
    private Integer id;					//id主键
    private Integer customerid;			//客户id,关联客户信息表',
    private Integer itype;				//类型[0公司1家2学校3其他]
	private Integer isex;				//性别[0先生1女士]
    private String sname;				//姓名
    private String sphone;				//电话
    private String sprovince;			//省份
    private String scity;				//城市
    private String sregion;				//地区
    private String saddress;			//详细地址(门牌号)
    private String spoiaddr;			//定位地址
    private BigDecimal dlng;			//经度
    private BigDecimal dlat;			//纬度
    private Integer isdefault;			//是否默认[0:否1:是]

	@JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef1;				// 自定义项1
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String sdef2;				// 自定义项2
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String sdef3;				// 自定义项3
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String sdef4;				// 自定义项4
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String sdef5;				// 自定义项5
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Integer idef6;				// 自定义项6
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Integer idef7;				// 自定义项7
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private BigDecimal ddef8;			// 自定义项8
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private BigDecimal ddef9;			// 自定义项9
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Date ddef10;				// 自定义项10
    

}