package com.yunniu.farming.webadmin.model;


import com.fasterxml.jackson.annotation.JsonInclude;
import com.yunniu.farming.common.plugin.PageInfo;
import lombok.Data;

import java.util.Date;
/**
 * 收益表
 */
@Data
public class Accountalterrec {

	
	
	//操作类型
	//10收入类[detailType:19提现退回]
	//20支出类[detailType:21提现申请]
	public static final Integer ITYPE_YJ_IN = 10;
    public static final Integer ITYPE_YJ_OUT = 20;
	//收入支出细类
	public static final Integer ITYPE_YJ_IN_VIPTJ = 11;
	public static final Integer ITYPE_YJ_IN_QDSD= 12;
	public static final Integer ITYPE_YJ_IN_REFUSE = 19;
    public static final Integer ITYPE_YJ_OUT_WITHDRAW = 21;


	//30收入类[detailType:39提现退回]
	//40支出类[detailType:41提现申请]
	public static final Integer ITYPE_JT_IN = 30;
	public static final Integer ITYPE_JT_OUT = 40;
	//收入支出细类
	public static final Integer ITYPE_JT_IN_TEAN = 31;
	public static final Integer ITYPE_JT_IN_LEVEL1 = 32;
	public static final Integer ITYPE_JT_IN_LEVEL2 = 33;
	public static final Integer ITYPE_JT_IN_REFUSE = 39;
	public static final Integer ITYPE_JT_OUT_WITHDRAW = 41;//提现申请


	//状态[0提现待审1提现成功2提现拒绝][99汇款失败]
	public static final Integer STATUS_WITHDRAW_AUDIT = 0;
	public static final Integer STATUS_WITHDRAW_OK = 1;
	public static final Integer STATUS_WITHDRAW_REFUSE = 2;
	public static final Integer STATUS_MAKEMONEY_FAIL = 99;

    //提现到账方式[10:微信零钱20:支付宝30:银行卡]
    public static final Integer ACCOUNT_WAY_WX = 10;
    public static final Integer ACCOUNT_WAY_ALIPAY = 20;
    public static final Integer ACCOUNT_WAY_BANK = 30;


	//----------------------- 辅助对象及字段定义，只作为传值，不用于数据库存储
	// 辅助对象:分页信息对象
	private PageInfo pageinfo;
	private Integer curpage;// 分页页码
	private Integer pagesize; // 分页个数

	//用户
	private Customer customer;

	private String nickname;

	//辅助字段
	private String beginDate;//辅助查询 查询开始时间
	private String endDate;	//辅助查询 查询结束时间

	private Double yjbalance; //余额
	private Double jtbalance; //余额

	private Integer itypecash;//查询提现申请

	private String method;


	//数据库字段定义
	private Integer id;//id主键
	private Integer customerid;//用户id
	private Integer orderid;//订单id
	private Integer productid;//商品id
	private Integer itype;//操作分类
	private Integer idetailtype; //详细分类
	private String sdesc;//收入/支出描述
	private String soperation;//操作说明或原因

    private Double drmbin;// 收入金额[格式#.##]
	private Double drmbout;//支出金额[格式#.##]

	private Double dcoinin;// 收入金额[格式#.##]
	private Double dcoinout;//支出金额[格式#.##]

    private Double drate;//手续费
	private Double damount;//实际到账单金额[提现金额-手续费]

    private Integer iarrivalway;//到账方式[10:微信零钱20:支付宝30:银行卡]
	private Integer icashtype;//提现类型
	private String swxopenid;//微信openid
	private String swxnickname;//微信昵称
    private String srealname;//真实姓名
    private String salipayaccount;//支付宝账号
    private String sbanktype;//银行类别
    private String sbankcardno;//银行卡号
    private Integer istatus;//状态[0提现待审 1提现成功 2提现拒绝 99汇款失败]
	private String sreason;//拒绝理由[拒绝时显示]
	private Date taudittime ;//审核时间
	private Date tcreatetime;//创建时间[yyyy-MM-dd hh:mm:ss]
	private String sremark;//备注

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String sdef1;//自定义项1
	@JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef2;//自定义项2
	@JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef3;//自定义项3
	@JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef4;//自定义项4
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String sdef5;//自定义项5
	@JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef6;//自定义项6
	@JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef7;//自定义项7
	@JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef8;//自定义项8
	@JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef9;//自定义项9
	@JsonInclude(JsonInclude.Include.NON_NULL)
    private String sdef10;//自定义10
	@JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer idef11;//自定义项11;
	@JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer idef12;//自定义项12
	@JsonInclude(JsonInclude.Include.NON_NULL)
    private Double ddef13;//自定义项13
	@JsonInclude(JsonInclude.Include.NON_NULL)
    private Double ddef14;//自定义项14
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Date ddef15;//自定义项15
	


}