package com.yunniu.farming.webadmin.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yunniu.farming.webadmin.model.Banner;
import com.yunniu.farming.webadmin.model.DocCatalog;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

public interface DocCatalogDao extends BaseMapper<DocCatalog> {


    int deleteByPrimaryKey(Integer id);


    DocCatalog selectByPrimaryKey(Integer id);


    /**
     * 查询所有导航分类档案
     * @param record
     * @return
     */
    List<DocCatalog> selectByParam(DocCatalog record);


    /**
     * 查询所有导航分类档案 优化后
     * @param record
     * @return
     */
    List<DocCatalog> getRoleInfo(DocCatalog record);



    /**
     * @参数查询子对象，用于一级分类及关联的二级子类查询
     * @param catalog
     * @return
     */
    List<DocCatalog> selectProSubByParam(DocCatalog catalog);



    @Select(value = {"<script>",
            "SELECT * FROM banner where banner_id = 1",
            "</script>"})
    Banner getBanner();


    @Update(value = {"<script>",
            "update banner set modified_time=now()",
            "<when test='bannerUrls !=null and bannerUrls !=\"\"'>, banner_urls=#{bannerUrls}</when>",
            "where banner_id=1",
            "</script>"})
    Integer updateBanner(Banner banner);

}