package com.yunniu.farming.webadmin.dao;


import com.yunniu.farming.webadmin.model.Article;

import java.util.List;

public interface ArticleDao {
	/**
	 * 按照条件增加
	 * @param article
	 * @return
	 */
	int insertSelective(Article article);
	/**
	 * 根据id删除
	 * @param id
	 * @return
	 */
	int deleteByid(Integer id);
	
	/**
	 * 按照条件更新
	 * @return
	 */
	int updateByPrimaryKeySelective(Article article);
	
	/**
	 * 带参分页查询对象
	 * @param map.pinfo => PageInfo 分页对象；
     * @param map.main => PaperMain 实体对象类；
	 * @return
	 */
	List<Article> findPageList(Article doc);
	
	/**
	 * 带参普通查询
	 * @param doc
	 * @return
	 */
	List<Article> findByParam(Article doc);
	/**
	  * 根据id查找
	 * @param id
	 * @return
	 */
	Article selectByPrimaryKey(Integer id);

    void speedreads(Article item);

	int findAdminCount(Article main);

	List<Article> findParamRead(Article doc);
}
