package com.yunniu.farming.webadmin.controller;


import com.yunniu.farming.util.DateTools;
import com.yunniu.farming.webadmin.dao.CustomerDao;
import com.yunniu.farming.webadmin.dao.GroupBuyDao;
import com.yunniu.farming.webadmin.dao.GroupOrderDao;
import com.yunniu.farming.webadmin.dao.OrderMainDao;
import com.yunniu.farming.webadmin.model.Customer;
import com.yunniu.farming.webadmin.model.GroupOrder;
import com.yunniu.farming.webadmin.model.OrderMain;
import com.yunniu.farming.webadmin.service.WxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Component
public class TaskJob {

    @Autowired
    private CustomerDao customerDao;
    @Autowired
    private GroupOrderDao groupOrderDao;
    @Autowired
    private OrderMainDao orderMainDao;
    @Autowired
    private WxService wxService;
    @Autowired
    private GroupBuyDao groupBuyDao;

    //定时任务
    @Scheduled(cron = "0 0 0 * * ? ") // 每天凌晨零点零分零秒
    //@Scheduled(cron = " 0 */1 * * * ? ") // 测试，每分钟更新一次
    public void timingJob() throws ParseException {

        //查询所有会员用户
        Customer customer = new Customer();
        customer.setIroleid(Customer.ROLE_CHARGE);//会员
        List<Customer> customers = customerDao.selectByParam(customer);

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String nowDay = DateTools.getDate("yyyy-MM-dd");
        Date now = sdf.parse(nowDay);
        if (customers != null && customers.size() > 0) {
            for (Customer task : customers) {
                //会员过期日期与当前日期进行比较 当前日期大于会员到期日期
                Date svip = sdf.parse(task.getSenddate());
                if (now.getTime() > svip.getTime()) {
                    //改变会员用户状态
                    this.updateUserVipStatus(task);
                }

            }
        }
    }

    /**
     * 定时修改团购订单状态
     */
    @Scheduled(cron = "0 0 * * * ? ")
    @Transactional(rollbackFor = Exception.class)
    public void successGroup() throws Exception {
        // 查询待成团并到期的团购订单
        List<GroupOrder> orders = groupOrderDao.getList();
        orders.forEach(order -> {
            order.setGroupStatus("4");
            // 查询已支付成功订单
            List<OrderMain> orderMains = orderMainDao.selectByGroupOrderId(order.getId());
            // 订单数小于成团数 拼团失败 进行退款
            if (order.getGroupSize() < orderMains.size()) {
                // 循环退款
                orderMains.forEach(orderMain -> {
                    try {
                        wxService.wxRefund(orderMain.getCustomerid(), orderMain.getId(), "拼团失败", null);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            groupOrderDao.updateById(order);
        });
    }

    /**
     * 定时失效团购活动
     */
    @Scheduled(cron = "0 * * * * ? ")
    public void activityFailure() {

        groupBuyDao.activityFailure(new Date());
    }

    /**
     * 定时失效团购活动
     */
    @Scheduled(cron = "0 * * * * ? ")
    public void activityValidation() {
        groupBuyDao.activityValidation(new Date());
    }


    //改变会员用户状态
    public void updateUserVipStatus(Customer user) {

        if (user == null) {
            return;
        }

        user.setIroleid(Customer.ROLE_NORMAL);//普通用户

        this.customerDao.updateById(user);

    }


}
