package com.yunniu.farming.webadmin.controller;

import com.alibaba.fastjson.JSONObject;

import com.yunniu.farming.config.ReturnResult;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.model.SysSet;
import com.yunniu.farming.webadmin.service.impl.SysSetServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;



/**
 * @功能：系统参数
 */
@Controller
@RequestMapping("/sysset")
public class SysSetController {
	

	@Autowired
	private SysSetServiceImpl service;



	@RequestMapping(value = "/list")
	public String setList(Model model) {
		model.addAttribute("list", service.findByParam());
		return "set/sysSet";
	}


	/**
	 * 新增
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/add",method = RequestMethod.POST)
	@ResponseBody
	public Result add(@RequestBody JSONObject json){
		SysSet item = JSONObject.toJavaObject(json,SysSet.class);
		return this.service.add(item);
	}
	
	/**
	 * 带参查询
	 * @return
	 */
	@RequestMapping(value = "/findByParam",method = RequestMethod.POST)
	@ResponseBody
	public ReturnResult findByEntity(){
		SysSet docs = this.service.findByParam();
		return ReturnResult.getSuccessResult(docs);
	}

	
	/**
	 * 根据id查找
	 * @param itemid
	 * @return
	 */
	@RequestMapping(value = "/{id}/findById", method = RequestMethod.GET)
    @ResponseBody
	public Result findById(@PathVariable Integer id){
		return this.service.finById(id);
	}


	/**
	 * 根据id更新
	 * @param  json 前台封装的json对象
	 * @return ReturnResult
	 */
	@RequestMapping(value = "/updateById",method = RequestMethod.POST)
	@ResponseBody
	public ReturnResult updateById(@RequestBody JSONObject json){
		
		//1. 将前台传过来的json对象转换成具有业务属性的 Java 对象
		SysSet user = JSONObject.toJavaObject(json,SysSet.class);
		
		//2. 调用service方法
		int result = this.service.update(user);
		
		return ReturnResult.getSuccessResult(result);
	}
	


}
