package com.yunniu.farming.webadmin.controller;

import com.alibaba.fastjson.JSONObject;
import com.yunniu.farming.common.plugin.PageInfo;
import com.yunniu.farming.config.ReturnResult;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.util.COSUtil;
import com.yunniu.farming.util.FileUtil;
import com.yunniu.farming.webadmin.model.DocCatalog;
import com.yunniu.farming.webadmin.model.Product;
import com.yunniu.farming.webadmin.service.impl.DocCatalogServiceImpl;
import com.yunniu.farming.webadmin.service.impl.ProductServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;



@Controller
@RequestMapping("/product")
public class ProductController {
	

	@Autowired
	private ProductServiceImpl service;

	@Autowired
	private DocCatalogServiceImpl docCatalogServiceImpl;


	@RequestMapping(value = "/list")
	public String goods(Model model) {
		return "goods/list";
	}

	@RequestMapping(value = "/zkList")
	public String zkList(Model model) {
		return "discountGoods/list";
	}

	@RequestMapping(value = "/inteList")
	public String inteList(Model model) {
		return "inteGoods/list";
	}


	@RequestMapping(value = "/addOrEdit")
	public String editGoods(Model model, Integer id) {
        DocCatalog docCatalog = new DocCatalog();
        docCatalog.setItype(DocCatalog.TYPE_PRO);
        List<DocCatalog> goodsClassList = docCatalogServiceImpl.findByParam(docCatalog);
        model.addAttribute("id", id);
		if (id == null || id.equals("")) {
			model.addAttribute("obj", new Product());
		} else {
			Product goods = service.findByid(id);
			model.addAttribute("obj", goods);
		}
        model.addAttribute("goodsClassList", goodsClassList);
		return "goods/addOrEdit";
	}


	@RequestMapping(value = "/addOrEditZk")
	public String addOrEditZk(Model model, Integer id) {
		model.addAttribute("id", id);
		if (id == null || id.equals("")) {
			model.addAttribute("obj", new Product());
		} else {
			Product goods = service.findByid(id);
			model.addAttribute("obj", goods);
		}
		return "discountGoods/addOrEdit";
	}


	@RequestMapping(value = "/addOrEditInte")
	public String addOrEditInte(Model model, Integer id) {
		DocCatalog docCatalog = new DocCatalog();
		docCatalog.setItype(DocCatalog.TYPE_PRO);
		List<DocCatalog> goodsClassList = docCatalogServiceImpl.findByParam(docCatalog);
		model.addAttribute("id", id);
		if (id == null || id.equals("")) {
			model.addAttribute("obj", new Product());
		} else {
			Product goods = service.findByid(id);
			model.addAttribute("obj", goods);
		}
		model.addAttribute("goodsClassList", goodsClassList);
		return "inteGoods/addOrEdit";
	}

	
	//---------------------增、删、改、查方法------------------------
	
	/**
	 * 新增、编辑 方法
	 */
	@RequestMapping(value = "/add", method = RequestMethod.POST)
	@ResponseBody
	public Result add(Product product) {

		return this.service.add(product);

	}

	
	/**
	 * 根据 ”多参数“ 查找对象集合
	 */
	@RequestMapping(value = "/findByParam",method = RequestMethod.POST)
	@ResponseBody
	public ReturnResult findByParam(@RequestBody Product item){
		
		List<Product> docs = this.service.findByParam(item);
		
		return ReturnResult.getSuccessResult(docs);
	}
	
	/**
	 * 根据 多参数 分页查找 对象集合
	 * 注意：这里分页是通过分页插件拦截器实现的，分页相关的数据是通过 查询参数对象 又重新返回了
	 * @return
	 */
	@RequestMapping(value = "/findPageList", method = RequestMethod.POST)
	@ResponseBody
	public Result findPageList(@RequestBody Product item){
		//这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
		Map<String, Object> rmap = new HashMap<String, Object>();

		//传入当前页数，适配PC端Layui分页
		if (item.getCurpage() != null || item.getPagesize() != null) {
			PageInfo pinfo = new PageInfo();

			if (item.getCurpage() != null) {
				pinfo.setCurPage(item.getCurpage());
			}
			if (item.getPagesize() != null) {
				pinfo.setPageSize(item.getPagesize());
			}
			item.setPageinfo(pinfo);
		}

		// 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
		PageInfo pinfo = item.getPageinfo();
		if (pinfo == null) {
			pinfo = new PageInfo();
			item.setPageinfo(pinfo);
		} else {
			// 分页开始记录数
			int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
			pinfo.setCurRecord(curRecord);
			item.setPageinfo(pinfo);
		}

		//
		// 2.1 执行主表 查询
		List<Product> list = this.service.findByParamPageList(item);

		// 3.将查询结果的 分页数据封装后返回
		int totalRs = pinfo.getTotalRecords();        //总记录数
		int totalPs = 0;                            //总页数
		if (totalRs % pinfo.getPageSize() == 0) {        //总页数计算
			totalPs = totalRs / pinfo.getPageSize();
		} else {
			totalPs = 1 + totalRs / pinfo.getPageSize();
		}
		pinfo.setTotalPages(totalPs);

		// 4.将分页对象、结果集合 封装后返回前台
		rmap.put("pageinfo", pinfo);
		rmap.put("items", list);

		return Result.success(rmap);
	}	

	/**
	 * 根据”对象id“ 查找对象
	 */
	@RequestMapping(value = "/{id}/findById", method = RequestMethod.GET)
	@ResponseBody
	public Result findById(@PathVariable Integer id){
		
		Product u = this.service.findByid(id);
		
		return Result.success(u);
	}
	
	/**
	 * 根据”对象id“ 删除对象
	 */
	@RequestMapping(value = "/{id}/deleteById", method = RequestMethod.GET)
    @ResponseBody
	public Result deleteById(@PathVariable Integer id){

		return this.service.deleteByid(id);

	}



	/**
	 * 根据id更新
	 */
	@RequestMapping(value = "/update",method = RequestMethod.POST)
	@ResponseBody
	public Result update(@RequestBody JSONObject json){
		
		Product user = JSONObject.toJavaObject(json,Product.class);
		
		return this.service.update(user);
		
	}



	//-------------------其他 业务方法-------------------------


	/**
	 * 折扣商品分页列表
	 * 注意：这里分页是通过分页插件拦截器实现的，分页相关的数据是通过 查询参数对象 又重新返回了
	 * @return
	 */
	@RequestMapping(value = "/findZkPageList", method = RequestMethod.POST)
	@ResponseBody
	public Result findZkPageList(@RequestBody Product item){
		//这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
		Map<String, Object> rmap = new HashMap<String, Object>();

		//传入当前页数，适配PC端Layui分页
		if (item.getCurpage() != null || item.getPagesize() != null) {
			PageInfo pinfo = new PageInfo();

			if (item.getCurpage() != null) {
				pinfo.setCurPage(item.getCurpage());
			}
			if (item.getPagesize() != null) {
				pinfo.setPageSize(item.getPagesize());
			}
			item.setPageinfo(pinfo);
		}

		// 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
		PageInfo pinfo = item.getPageinfo();
		if (pinfo == null) {
			pinfo = new PageInfo();
			item.setPageinfo(pinfo);
		} else {
			// 分页开始记录数
			int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
			pinfo.setCurRecord(curRecord);
			item.setPageinfo(pinfo);
		}

		//
		// 2.1 执行主表 查询
		List<Product> list = this.service.findByParamZkPageList(item);

		// 3.将查询结果的 分页数据封装后返回
		int totalRs = pinfo.getTotalRecords();        //总记录数
		int totalPs = 0;                            //总页数
		if (totalRs % pinfo.getPageSize() == 0) {        //总页数计算
			totalPs = totalRs / pinfo.getPageSize();
		} else {
			totalPs = 1 + totalRs / pinfo.getPageSize();
		}
		pinfo.setTotalPages(totalPs);

		// 4.将分页对象、结果集合 封装后返回前台
		rmap.put("pageinfo", pinfo);
		rmap.put("items", list);

		return Result.success(rmap);
	}



	/**
	 * 积分商品分页列表
	 * 注意：这里分页是通过分页插件拦截器实现的，分页相关的数据是通过 查询参数对象 又重新返回了
	 * @return
	 */
	@RequestMapping(value = "/findIntePageList", method = RequestMethod.POST)
	@ResponseBody
	public Result findIntePageList(@RequestBody Product item){
		//这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
		Map<String, Object> rmap = new HashMap<String, Object>();

		//传入当前页数，适配PC端Layui分页
		if (item.getCurpage() != null || item.getPagesize() != null) {
			PageInfo pinfo = new PageInfo();

			if (item.getCurpage() != null) {
				pinfo.setCurPage(item.getCurpage());
			}
			if (item.getPagesize() != null) {
				pinfo.setPageSize(item.getPagesize());
			}
			item.setPageinfo(pinfo);
		}

		// 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
		PageInfo pinfo = item.getPageinfo();
		if (pinfo == null) {
			pinfo = new PageInfo();
			item.setPageinfo(pinfo);
		} else {
			// 分页开始记录数
			int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
			pinfo.setCurRecord(curRecord);
			item.setPageinfo(pinfo);
		}

		//
		// 2.1 执行主表 查询
		List<Product> list = this.service.findByParamIntePageList(item);

		// 3.将查询结果的 分页数据封装后返回
		int totalRs = pinfo.getTotalRecords();        //总记录数
		int totalPs = 0;                            //总页数
		if (totalRs % pinfo.getPageSize() == 0) {        //总页数计算
			totalPs = totalRs / pinfo.getPageSize();
		} else {
			totalPs = 1 + totalRs / pinfo.getPageSize();
		}
		pinfo.setTotalPages(totalPs);

		// 4.将分页对象、结果集合 封装后返回前台
		rmap.put("pageinfo", pinfo);
		rmap.put("items", list);

		return Result.success(rmap);
	}


	@RequestMapping(value = "uploads")
	@ResponseBody
	public Map<String, Object> uploads(@RequestParam(value = "upfile", required = false) MultipartFile upfile)
			throws Exception {
		Map<String, Object> rs = new HashMap<String, Object>();
		try {
			if (!upfile.isEmpty()) {
				String path = FileUtil.saveFile(upfile, "img");
				String url = COSUtil.uploadFileByPath(path);
				rs.put("state", "SUCCESS");// UEDITOR的规则:不为SUCCESS则显示state的内容
				rs.put("url", url); // 能访问到你如今图片的路径
			}
		} catch (Exception e) {
			e.printStackTrace();
			rs.put("state", e.getMessage());
			rs.put("url", "");
			rs.put("title", "");
			rs.put("original", "");
		}
		return rs;
	}












}
