package com.yunniu.farming.webadmin.controller;

import com.alibaba.fastjson.JSONObject;
import com.yunniu.farming.config.ReturnResult;
import com.yunniu.farming.webadmin.model.OrderSub;
import com.yunniu.farming.webadmin.service.impl.OrderSubServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@RestController
@RequestMapping("/app/ordersub")
public class OrderSubController {

    @Autowired
    private OrderSubServiceImpl orderSubService;






    /**
     * 新增、编辑 方法
     *
     * @param JSONObject userJson前台封装的json对象
     * @return ReturnResult
     */
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    @ResponseBody
    public ReturnResult add(@RequestBody JSONObject json) {

        // 1. 将前台传过来的json对象转换成具有业务属性的 Java 对象
        OrderSub osub = JSONObject.toJavaObject(json, OrderSub.class);

        // 保存订单主表信息
        osub = this.orderSubService.add(osub);

        return ReturnResult.getSuccessResult(osub);
    }


    /**
     * 更新
     * @param json
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    @ResponseBody
    public ReturnResult update(@RequestBody JSONObject json) {
        // 1. 将前台传过来的json对象转换成具有业务属性的 Java 对象
        OrderSub osub = JSONObject.toJavaObject(json, OrderSub.class);

        // 2. 调用service方法
        this.orderSubService.update(osub);

        return ReturnResult.getSuccessResult(osub);
    }




    /**
     * 根据”对象id“ 查找对象
     *
     * @param id =对象id
     * @return ReturnResult 单个JavaObject
     */
    @RequestMapping(value = "/{id}/findByid", method = RequestMethod.GET)
    @ResponseBody
    public ReturnResult findById(@PathVariable Integer id) {

        // 1. 调用Service方法
        OrderSub item = this.orderSubService.findByid(id);

        // 2. 返回查询结果
        return ReturnResult.getSuccessResult(item);
    }

    /**
     * 根据”对象id“ 删除对象
     *
     * @param id =对象id
     * @return ReturnResult
     */
    @RequestMapping(value = "/{id}/deleteById", method = RequestMethod.POST)
    @ResponseBody
    public ReturnResult deleteById(@PathVariable Integer id) {
        // 1. 调用Service方法
        int deleteR = this.orderSubService.deleteByid(id);

        // 2. 返回查询结果
        return ReturnResult.getSuccessResult(deleteR);
    }








}
