package com.yunniu.farming.webadmin.controller;

import com.alibaba.fastjson.JSONObject;
import com.yunniu.farming.common.plugin.PageInfo;
import com.yunniu.farming.config.ReturnResult;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.model.OrderMain;
import com.yunniu.farming.webadmin.model.OrderSub;
import com.yunniu.farming.webadmin.service.impl.OrderMainServiceImpl;
import com.yunniu.farming.webadmin.service.impl.OrderSubServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import java.util.*;


@Controller
@RequestMapping("/order")
public class OrderMainController {

    @Autowired
    private OrderMainServiceImpl orderService;
    @Autowired
    private OrderSubServiceImpl subService;



    @RequestMapping(value = "/loanList")
    public String loanList(Model model) {
        return "order/loanList";
    }
    @RequestMapping(value = "/refundList")
    public String refundList(Model model) {
        return "order/refundList";
    }

    @RequestMapping(value = "/vipList")
    public String vipList(Model model) {
        return "order/vipList";
    }

    @RequestMapping(value = "/orderDetail")
    public String orderDetail(Model model, Integer orderId) {
        model.addAttribute("orderId", orderId);
        return "order/detailList";
    }


    /**
     * 多参数条件分页
     */
    @RequestMapping(value = "/findPageList", method = RequestMethod.POST)
    @ResponseBody
    public Result findPageList(@RequestBody OrderMain item) {

        //这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
        Map<String,Object> rmap = new HashMap<String,Object>();

        //传入当前页数，适配PC端Layui分页
        if(item.getCurpage() != null || item.getPagesize() != null) {
            PageInfo pinfo = new PageInfo();

            if(item.getCurpage() != null) {
                pinfo.setCurPage(item.getCurpage());
            }

            if(item.getPagesize() != null) {
                pinfo.setPageSize(item.getPagesize());
            }
            item.setPageinfo(pinfo);
        }

        // 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
        PageInfo pinfo = item.getPageinfo();
        if(pinfo == null) {
            pinfo = new PageInfo();
            item.setPageinfo(pinfo);
        }else{
            // 分页开始记录数
            int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
            pinfo.setCurRecord(curRecord);
            item.setPageinfo(pinfo);
        }
        // 2.1 执行主表 查询
        List<OrderMain> items=this.orderService.selectByParamPageList(item);

        // 3.将查询结果的 分页数据封装后返回
        int totalRs = pinfo.getTotalRecords();		//总记录数
        int totalPs = 0;					  		//总页数
        if(totalRs % pinfo.getPageSize() == 0){		//总页数计算
            totalPs = totalRs / pinfo.getPageSize() ;
        }else{
            totalPs = 1 + totalRs / pinfo.getPageSize() ;
        }
        pinfo.setTotalPages(totalPs);

        // 4.将分页对象、结果集合 封装后返回前台
        rmap.put("pageinfo", pinfo);
        rmap.put("items", items);
        return Result.success(rmap);
    }


    /**
     * 多参数条件分页
     * 查询订单子表
     */
    @RequestMapping(value = "/findSubPageList", method = RequestMethod.POST)
    @ResponseBody
    public ReturnResult findSubPageList(@RequestBody OrderSub item) {
        //这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
        Map<String,Object> rmap = new HashMap<String,Object>();

        //传入当前页数，适配PC端Layui分页
        if(item.getCurpage() != null || item.getPagesize() != null) {
            PageInfo pinfo = new PageInfo();

            if(item.getCurpage() != null) {
                pinfo.setCurPage(item.getCurpage());
            }

            if(item.getPagesize() != null) {
                pinfo.setPageSize(item.getPagesize());
            }
            item.setPageinfo(pinfo);
        }

        // 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
        PageInfo pinfo = item.getPageinfo();
        if(pinfo == null) {
            pinfo = new PageInfo();
            item.setPageinfo(pinfo);
        }else{
            // 分页开始记录数
            int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
            pinfo.setCurRecord(curRecord);
            item.setPageinfo(pinfo);
        }
        // 2.1 执行主表 查询
        List<OrderSub> items=this.subService.selectSubByParamPageList(item);

        // 3.将查询结果的 分页数据封装后返回
        int totalRs = pinfo.getTotalRecords();		//总记录数
        int totalPs = 0;					  		//总页数
        if(totalRs % pinfo.getPageSize() == 0){		//总页数计算
            totalPs = totalRs / pinfo.getPageSize() ;
        }else{
            totalPs = 1 + totalRs / pinfo.getPageSize() ;
        }
        pinfo.setTotalPages(totalPs);

        // 4.将分页对象、结果集合 封装后返回前台
        rmap.put("pageinfo", pinfo);
        rmap.put("items", items);
        return ReturnResult.getSuccessResult(rmap);
    }


    /**
     * 团购退款订单列表
     */
    @RequestMapping(value = "/findPageRefundList", method = RequestMethod.POST)
    @ResponseBody
    public Result findPageRefundList(@RequestBody OrderMain item) {

        //这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
        Map<String,Object> rmap = new HashMap<String,Object>();

        //传入当前页数，适配PC端Layui分页
        if(item.getCurpage() != null || item.getPagesize() != null) {
            PageInfo pinfo = new PageInfo();

            if(item.getCurpage() != null) {
                pinfo.setCurPage(item.getCurpage());
            }

            if(item.getPagesize() != null) {
                pinfo.setPageSize(item.getPagesize());
            }
            item.setPageinfo(pinfo);
        }

        // 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
        PageInfo pinfo = item.getPageinfo();
        if(pinfo == null) {
            pinfo = new PageInfo();
            item.setPageinfo(pinfo);
        }else{
            // 分页开始记录数
            int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
            pinfo.setCurRecord(curRecord);
            item.setPageinfo(pinfo);
        }
        // 2.1 执行主表 查询
        List<OrderMain> items=this.orderService.selectByParamPageRefundGroupList(item);

        // 3.将查询结果的 分页数据封装后返回
        int totalRs = pinfo.getTotalRecords();		//总记录数
        int totalPs = 0;					  		//总页数
        if(totalRs % pinfo.getPageSize() == 0){		//总页数计算
            totalPs = totalRs / pinfo.getPageSize() ;
        }else{
            totalPs = 1 + totalRs / pinfo.getPageSize() ;
        }
        pinfo.setTotalPages(totalPs);

        // 4.将分页对象、结果集合 封装后返回前台
        rmap.put("pageinfo", pinfo);
        rmap.put("items", items);
        return Result.success(rmap);
    }

    /**
     *  多参数查询列表
     */
    @RequestMapping(value = "/findByParam", method = RequestMethod.POST)
    @ResponseBody
    public Result findByParam(@RequestBody OrderMain item) {

        List<OrderMain> docs = this.orderService.findByParam(item);

        return Result.success(docs);
    }


    /**
     * 更新订单
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    @ResponseBody
    public Result update(@RequestBody JSONObject json) {

        OrderMain orderM = JSONObject.toJavaObject(json, OrderMain.class);

        return this.orderService.update(orderM);

    }


    /**
     * 根据”对象id“ 查找对象
     */
    @RequestMapping(value = "/{id}/findById", method = RequestMethod.GET)
    @ResponseBody
    public Result findById(@PathVariable Integer id) {

        OrderMain titem = this.orderService.findByid(id);

        return Result.success(titem);
    }



    /**
     * 根据”对象id“ 删除对象
     */
    @RequestMapping(value = "/{id}/deleteById", method = RequestMethod.POST)
    @ResponseBody
    public Result deleteById(@PathVariable Integer id) {

        return this.orderService.deleteByid(id);

    }




    /**
     * 	根据参数，查询订单数量
     */
    @RequestMapping(value = "/findOrderNum",method = RequestMethod.POST)
    @ResponseBody
    public Result findOrderNum(@RequestBody JSONObject json){

        OrderMain user = JSONObject.toJavaObject(json,OrderMain.class);

        int orderNum = this.orderService.findOrderNum(user);

        return Result.success(orderNum);

    }


    /**
     * 	根据参数，查询订单金额
     */
    @RequestMapping(value = "/findOrderMoney",method = RequestMethod.POST)
    @ResponseBody
    public Result findOrderMoney(@RequestBody JSONObject json){

        OrderMain orderMain = JSONObject.toJavaObject(json,OrderMain.class);

        Double orderMoney = this.orderService.findOrderMoney(orderMain);

        return Result.success(orderMoney);

    }



    /**
     * 	订单已发货
     */
    @RequestMapping(value = "/updateFwStatus",method = RequestMethod.POST)
    @ResponseBody
    public Result updateFwStatus(@RequestBody JSONObject json){

        OrderMain user = JSONObject.toJavaObject(json,OrderMain.class);

        return this.orderService.updateFwStatus(user);

    }

    /**
     * 	退款申请通过
     */
    @RequestMapping(value = "/refundApplicationPass",method = RequestMethod.POST)
    @ResponseBody
    public Result refundApplicationPass(@RequestBody JSONObject json){
        OrderMain user = JSONObject.toJavaObject(json,OrderMain.class);
        return this.orderService.refundApplicationPass(user);
    }
    /**
     * 	退款申请拒绝
     */
    @RequestMapping(value = "/refundApplicationRefuse",method = RequestMethod.POST)
    @ResponseBody
    public Result refundApplicationRefuse(@RequestBody JSONObject json){
        OrderMain user = JSONObject.toJavaObject(json,OrderMain.class);
        return this.orderService.refundApplicationRefuse(user);
    }

    /**
     * 已收到退回货物，开始退款
     */
    @RequestMapping(value = "/receive",method = RequestMethod.POST)
    @ResponseBody
    public Result refundReceive(@RequestBody JSONObject json){
        OrderMain user = JSONObject.toJavaObject(json,OrderMain.class);
        return this.orderService.refundReceive(user, 4);
    }

    /**
     * 	订单已完成
     */
    @RequestMapping(value = "/updateOkStatus",method = RequestMethod.POST)
    @ResponseBody
    public Result updateOkStatus(@RequestBody JSONObject json){

        OrderMain user = JSONObject.toJavaObject(json,OrderMain.class);

        return this.orderService.updateOkStatus(user);

    }


    /**
     * 积分兑换 商品
     */
    @RequestMapping(value = "/integralPay", method = RequestMethod.POST)
    public Result integralPay(Integer userId, Integer orderId){

        return this.orderService.integralPay(userId,orderId);

    }



}
