package com.yunniu.farming.webadmin.controller;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.yunniu.farming.common.plugin.PageInfo;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.model.Banner;
import com.yunniu.farming.webadmin.model.GroupArea;
import com.yunniu.farming.webadmin.model.GroupBuy;
import com.yunniu.farming.webadmin.model.Product;
import com.yunniu.farming.webadmin.service.GroupAreaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zyf
 * @date 2023/5/12
 * @apiNote
 */
@Controller
@RequestMapping("/groupArea")
public class GroupAreaController {

    @Autowired
    private GroupAreaService groupAreaService;

    @RequestMapping(value = "/list")
    public String list(Model model) {
        return "groupArea/list";
    }

    @RequestMapping(value = "/addOrEdit")
    public String addOrEdit(Model model, Long areaId) {
        model.addAttribute("areaId", areaId);
        if (areaId == null || areaId.equals("")) {
            model.addAttribute("obj", new GroupArea());
        } else {
            GroupArea area = groupAreaService.findById(areaId);
            model.addAttribute("obj", area);
        }
        return "groupArea/addOrEdit";
    }

    /**
     * 分页查询
     * @return
     */
    @RequestMapping(value = "/findPageList", method = RequestMethod.POST)
    @ResponseBody
    public Result findPageList(@RequestBody GroupArea item) {
        //这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
        Map<String,Object> rmap = new HashMap<String,Object>(2);

        //传入当前页数，适配PC端Layui分页
        if (item.getCurpage() != null || item.getPagesize() != null) {
            PageInfo pinfo = new PageInfo();

            if (item.getCurpage() != null) {
                pinfo.setCurPage(item.getCurpage());
            }
            if (item.getPagesize() != null) {
                pinfo.setPageSize(item.getPagesize());
            }
            item.setPageinfo(pinfo);
        }
        // 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
        PageInfo pinfo = item.getPageinfo();
        if (pinfo == null) {
            pinfo = new PageInfo();
            item.setPageinfo(pinfo);
        } else {
            // 分页开始记录数
            int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
            pinfo.setCurRecord(curRecord);
            item.setPageinfo(pinfo);
        }

        List<GroupArea> list = groupAreaService.getPageList(item);

        // 3.将查询结果的 分页数据封装后返回
        int totalRs = pinfo.getTotalRecords();        //总记录数
        int totalPs = 0;                            //总页数
        if (totalRs % pinfo.getPageSize() == 0) {        //总页数计算
            totalPs = totalRs / pinfo.getPageSize();
        } else {
            totalPs = 1 + totalRs / pinfo.getPageSize();
        }
        pinfo.setTotalPages(totalPs);

        // 4.将分页对象、结果集合 封装后返回前台
        rmap.put("pageinfo", pinfo);
        rmap.put("items", list);
        return Result.success(rmap);
    }



    @RequestMapping(value = "/addOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public Result addOrUpdate(@RequestBody GroupArea item) {
        if (StringUtils.isEmpty(item.getAreaName())) {
            return Result.error("小区名称不能为空");
        }
        if (StringUtils.isEmpty(item.getAreaAddress())){
            return Result.error("小区地址不能为空");
        }
       return this.groupAreaService.addOrEdit(item);
    }

    @RequestMapping(value = "/delete/{id}", method = RequestMethod.GET)
    @ResponseBody
    public Result delete(@PathVariable Integer id) {
        if (id == null) {
            return Result.error("请选择要删除的小区");
        }
        return this.groupAreaService.delete(id);
    }
}
