package com.yunniu.farming.webadmin.controller;

import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.model.Banner;
import com.yunniu.farming.webadmin.model.DocCatalog;
import com.yunniu.farming.webadmin.service.impl.DocCatalogServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Controller
@RequestMapping("/catalog")
public class DocCatalogController {

	@Autowired
	private DocCatalogServiceImpl catalogServiceImpl;



	@RequestMapping(value = "/list")
	public String goodsClass(Model model) {
		return "goodsClass/list";
	}



	@RequestMapping(value = "/addOrEdit")
	public String addOrEdit(Model model, String id) {
		model.addAttribute("id", id);
		return "goodsClass/edit";
	}


	@RequestMapping(value = "/toBanner")
	public String toBanner(Model model) {
		model.addAttribute("obj", catalogServiceImpl.getBanner());
		return "goodsClass/banner";
	}

	/**
	 * @参数查询商品分类，带分类商品
	 */
	@RequestMapping(value = "/findProSubs", method = RequestMethod.POST)
	@ResponseBody
	public Result findProSubs(@RequestBody DocCatalog item){

		item.setItype(DocCatalog.TYPE_PRO);//商品

		return this.catalogServiceImpl.selectProSubByParam(item);

	}


	@RequestMapping(value = "/del", method = RequestMethod.POST)
	@ResponseBody
	public Result delGoodsClass(Integer id) {
		return catalogServiceImpl.deleteById(id);
	}

	/**
	 *  根据 ”多参数“ 查找对象集合
	 */
	@RequestMapping(value = "/findByParam",method = RequestMethod.POST)
	@ResponseBody
	public Result findByParam(@RequestBody DocCatalog item){

		List<DocCatalog> docs = this.catalogServiceImpl.findByParam(item);

		return Result.success(docs);

	}


	//增加或修改分类
	@RequestMapping(value = "/updateGoodsClass", method = RequestMethod.POST)
	@ResponseBody
	public Result updateGoodsClass(DocCatalog goodsClass) {
		return catalogServiceImpl.updateGoodsClass(goodsClass);
	}



	@RequestMapping(value = "/getGoodsClassById", method = RequestMethod.POST)
	@ResponseBody
	public DocCatalog getGoodsClassById(String id) {
		return catalogServiceImpl.findById(Integer.valueOf(id));
	}


	@RequestMapping(value = "/updateBanner", method = RequestMethod.POST)
	@ResponseBody
	public Result updateBanner(Banner banner) {
		Result result = catalogServiceImpl.updateBanner(banner);
		return result;
	}

	

}
