package com.yunniu.farming.webadmin.controller;

import com.alibaba.fastjson.JSONObject;
import com.yunniu.farming.common.plugin.PageInfo;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.model.Customer;
import com.yunniu.farming.webadmin.service.impl.CustomerServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Controller
@RequestMapping("/customer")
public class CustomerController {

    @Autowired
    private CustomerServiceImpl customerService;



    @RequestMapping(value = "/list")
    public String list(Model model) {
        return "customer/list";
    }


    @RequestMapping(value = "/countList")
    public String countList(Model model) {
        return "customer/countList";
    }

    @RequestMapping(value = "/setVip")
    public String setVip(Model model,Integer id) {
        model.addAttribute("userId", id);
        return "customer/vipEdit";
    }


    /**
     * 根据 Object对象参数 查找 对象列表
     * 带参 分页查询
     * 注意：这里分页是通过分页插件拦截器实现的，分页相关的数据是通过 查询参数对象 又重新返回了
     * @return
     */
    @RequestMapping(value = "/findPageList", method = RequestMethod.POST)
    @ResponseBody
    public Result findPageList(@RequestBody Customer doc){

        //这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
        Map<String,Object> rmap = new HashMap<String,Object>();

        // 分页数据处理

        // 传入当前页数，适配PC端Layui分页
        if(doc.getCurpage() != null || doc.getPagesize() != null) {
            PageInfo pinfo = new PageInfo();

            if(doc.getCurpage() != null) {
                pinfo.setCurPage(doc.getCurpage());
            }

            if(doc.getPagesize() != null) {
                pinfo.setPageSize(doc.getPagesize());
            }
            doc.setPageinfo(pinfo);
        }
        // 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
        PageInfo pinfo = doc.getPageinfo();

        if(pinfo == null) {
            pinfo = new PageInfo();
            doc.setPageinfo(pinfo);
        }else{
            // 分页开始记录数
            int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
            pinfo.setCurRecord(curRecord);
            doc.setPageinfo(pinfo);
        }

        // 2.1 执行主表 查询
        List<Customer> docs = this.customerService.selectByParamPageList(doc);

        // 3.将查询结果的 分页数据封装后返回
        //总记录数
        int totalRs = pinfo.getTotalRecords();
        //总页数
        int totalPs = 0;
        //总页数计算
        if(totalRs % pinfo.getPageSize() == 0){
            totalPs = totalRs / pinfo.getPageSize() ;
        }else{
            totalPs = 1 + totalRs / pinfo.getPageSize() ;
        }
        pinfo.setTotalPages(totalPs);

        // 4.将分页对象、结果集 封装后返回前台
        rmap.put("pageinfo", pinfo);
        rmap.put("items", docs);

        return Result.success(rmap);

    }






    /**
     * 根据 Object对象参数 查找 对象列表
     * 带参 分页查询 带数据统计
     * 注意：这里分页是通过分页插件拦截器实现的，分页相关的数据是通过 查询参数对象 又重新返回了
     * @return
     */
    @RequestMapping(value = "/findCountPageList", method = RequestMethod.POST)
    @ResponseBody
    public Result findCountPageList(@RequestBody Customer doc){

        //这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
        Map<String,Object> rmap = new HashMap<String,Object>();

        // 分页数据处理

        // 传入当前页数，适配PC端Layui分页
        if(doc.getCurpage() != null || doc.getPagesize() != null) {
            PageInfo pinfo = new PageInfo();

            if(doc.getCurpage() != null) {
                pinfo.setCurPage(doc.getCurpage());
            }

            if(doc.getPagesize() != null) {
                pinfo.setPageSize(doc.getPagesize());
            }
            doc.setPageinfo(pinfo);
        }
        // 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
        PageInfo pinfo = doc.getPageinfo();

        if(pinfo == null) {
            pinfo = new PageInfo();
            doc.setPageinfo(pinfo);
        }else{
            // 分页开始记录数
            int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
            pinfo.setCurRecord(curRecord);
            doc.setPageinfo(pinfo);
        }

        // 2.1 执行主表 查询
        List<Customer> docs = this.customerService.selectCountByParamPageList(doc);

        // 3.将查询结果的 分页数据封装后返回
        //总记录数
        int totalRs = pinfo.getTotalRecords();
        //总页数
        int totalPs = 0;
        //总页数计算
        if(totalRs % pinfo.getPageSize() == 0){
            totalPs = totalRs / pinfo.getPageSize() ;
        }else{
            totalPs = 1 + totalRs / pinfo.getPageSize() ;
        }
        pinfo.setTotalPages(totalPs);

        // 4.将分页对象、结果集 封装后返回前台
        rmap.put("pageinfo", pinfo);
        rmap.put("items", docs);

        return Result.success(rmap);

    }






    /**
     * FRICE TODO 根据 ”多参数“ 查找对象集合
     *
     * @param Customer Java对象
     * @return ReturnResult 对象列表List<JavaObject>
     */
    @RequestMapping(value = "/findByParam", method = RequestMethod.POST)
    @ResponseBody
    public Result findByParam(@RequestBody Customer item) {

        // 1. 调用 Service 方法
        List<Customer> docs = this.customerService.findByParam(item);

        // 2. 返回查询结果
        return Result.success(docs);
    }



    /**
     * 更新
     * @param json1
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    @ResponseBody
    public Result update(@RequestBody JSONObject json) {
        // 1. 将前台传过来的json对象转换成具有业务属性的 Java 对象
        Customer user = JSONObject.toJavaObject(json, Customer.class);

        // 2. 调用service方法
        this.customerService.update(user);

        return Result.success(user);
    }




    /**
     * 新增、编辑 方法
     *
     */
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    @ResponseBody
    public Result add(@RequestBody JSONObject json) {

        // 将前台传过来的json对象转换成具有业务属性的 Java 对象
        Customer user = JSONObject.toJavaObject(json, Customer.class);

        // 保存订单主表信息
        user = this.customerService.add(user);

        return Result.success(user);
    }

    /**
     * 根据”对象id“ 查找对象
     *
     * @param id =对象id
     * @return ReturnResult 单个JavaObject
     */
    @RequestMapping(value = "/{id}/findById", method = RequestMethod.GET)
    @ResponseBody
    public Result findById(@PathVariable Integer id) {

        // 1. 调用Service方法
        Customer item = this.customerService.findByid(id);

        // 2. 返回查询结果
        return Result.success(item);
    }

    /**
     * 根据”对象id“ 删除对象
     *
     * @param id =对象id
     * @return ReturnResult
     */
    @RequestMapping(value = "/{id}/deleteById", method = RequestMethod.POST)
    @ResponseBody
    public Result deleteById(@PathVariable Integer id) {
        // 1. 调用Service方法
        int deleteR = this.customerService.deleteByid(id);

        // 2. 返回查询结果
        return Result.success(deleteR);
    }





    //用户增加积分
    @RequestMapping(value = "/addIntegral", method = RequestMethod.POST)
    @ResponseBody
    public Result addIntegral(@RequestBody JSONObject json) {

        Customer user = JSONObject.toJavaObject(json, Customer.class);

        return this.customerService.addIntegral(user);


    }



}
