package com.yunniu.farming.webadmin.controller;


import com.yunniu.farming.common.plugin.PageInfo;
import com.yunniu.farming.config.ReturnResult;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.model.Banner;
import com.yunniu.farming.webadmin.model.Product;
import com.yunniu.farming.webadmin.service.impl.BannerServiceImpl;
import com.yunniu.farming.webadmin.service.impl.ProductServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Controller
@RequestMapping("/banner")
public class BannerController {
	
	@Autowired
	private BannerServiceImpl service;

	@Autowired
	private ProductServiceImpl productService;


	@RequestMapping(value = "/list")
	public String list(Model model) {
		return "banner/list";
	}





	@RequestMapping(value = "/addOrEdit")
	public String addOrEdit(Model model, Integer bannerId) {
		List<Product> goodsList = productService.findByParam(new Product());
		model.addAttribute("bannerId", bannerId);
		if (bannerId == null || bannerId.equals("")) {
			model.addAttribute("obj", new Banner());
		} else {
			Banner Banner = service.findById(bannerId);
			model.addAttribute("obj", Banner);
		}
		model.addAttribute("goodsList", goodsList);
		return "banner/addOrEdit";
	}



	/**
	 * 根据 对象id 删除对象
	 */
	@RequestMapping(value = "/{id}/deleteById", method = RequestMethod.GET)
	@ResponseBody
	public Result deleteByid(@PathVariable Integer id){
		//调用service 方法 返回结果
		return this.service.deleteByid(id);
	}
	
	/**
	 * 多参数条件分页
	 */
	@RequestMapping("/findPageList")
	@ResponseBody
	public Result findPageList(@RequestBody Banner item){
		
		//这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
		Map<String,Object> rmap = new HashMap<String,Object>();
		
		//传入当前页数，适配PC端Layui分页
		if(item.getCurpage() != null || item.getPagesize() != null) {
			PageInfo pinfo = new PageInfo();
			
			if(item.getCurpage() != null) {
				pinfo.setCurPage(item.getCurpage());
			}
			
			if(item.getPagesize() != null) {
				pinfo.setPageSize(item.getPagesize());
			}
			item.setPageinfo(pinfo);
		}
		
		// 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
		PageInfo pinfo = item.getPageinfo();
		if(pinfo == null) {
			pinfo = new PageInfo();
			item.setPageinfo(pinfo);
		}else{
			// 分页开始记录数
			int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
			pinfo.setCurRecord(curRecord);
			item.setPageinfo(pinfo);
		}
		// 2.1 执行主表 查询
		List<Banner> items = this.service.findPageList(item);
		// 3.将查询结果的 分页数据封装后返回
		int totalRs = pinfo.getTotalRecords();		//总记录数
		int totalPs = 0;					  		//总页数
		if(totalRs % pinfo.getPageSize() == 0){		//总页数计算
			totalPs = totalRs / pinfo.getPageSize() ;
		}else{
			totalPs = 1 + totalRs / pinfo.getPageSize() ;
		}
		pinfo.setTotalPages(totalPs);

		// 4.将分页对象、结果集合 封装后返回前台
		rmap.put("pageinfo", pinfo);
		rmap.put("items", items);
		return Result.success(rmap);
		
	}

	
	/**
	 * 根据 多参数查询对象结合
	 */
	@RequestMapping("/findByParam")
	@ResponseBody
	public Result findByParam(){
		//调用service 方法 返回查询结果集
		return this.service.findByParam();
	}




	
	/**
	 * 根据”对象id“ 查找对象
	 */
	@GetMapping(value = "/getInfo")
	public Result findById(Integer id){
		
		//1. 调用Service方法
		 Banner  banner= this.service.findById(id);
		//2. 返回查询结果
		return Result.success(banner);
	}



	@RequestMapping(value = "/add", method = RequestMethod.POST)
	@ResponseBody
	public Result add(Banner banner) {

		return this.service.add(banner);

	}


}
