package com.yunniu.farming.webadmin.controller;


import com.alibaba.fastjson.JSONObject;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.model.Address;
import com.yunniu.farming.webadmin.service.impl.AddressServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

/**
 * 地址
 */

@Controller
@RequestMapping("/address")
public class AddressController {
	

	@Autowired
	private AddressServiceImpl service;


	@RequestMapping(value = "/list")
	public String address(Model model) {
		return "address/list";
	}

	
	//---------------------增、删、改、查方法------------------------
	
	/**
	 * 新增、编辑 方法
	 */
	@RequestMapping(value = "/add",method = RequestMethod.POST)
	@ResponseBody
	public Result add(@RequestBody JSONObject json){

		Address address = JSONObject.toJavaObject(json,Address.class);

		return this.service.add(address);
		
	}


	/**
	 * 编辑 方法
	 */
	@RequestMapping(value = "/update",method = RequestMethod.POST)
	@ResponseBody
	public Result update(@RequestBody JSONObject json){

		Address address = JSONObject.toJavaObject(json,Address.class);

		return this.service.update(address);

	}


	
	/**
	 * 根据 ”多参数“ 查找对象集合   带分页
	 */
	@RequestMapping(value = "/findPageList",method = RequestMethod.POST)
	@ResponseBody
	public Result findPageList(@RequestBody Address address){
		//2. 返回查询结果
		return this.service.findPageList(address);
	}
	
	/**
	 * 根据 ”多参数“ 查找对象集合  不带分页
	 */
	@RequestMapping(value = "/findByParam",method = RequestMethod.POST)
	@ResponseBody
	public Result findByParam(@RequestBody Address address){
		//2. 返回查询结果
		return service.findByParam(address);
	}
	

	/**
	 * 根据”对象id“ 查找对象
	 * @param id=对象id
	 * @return ReturnResult 单个JavaObject
	 */
	@RequestMapping(value = "/{id}/findById", method = RequestMethod.GET)
	@ResponseBody
	public Result findById(@PathVariable Integer id){
		
		//1. 调用Service方法
		Address u = this.service.findByid(id);
		
		//2. 返回查询结果
		return Result.success(u);
	}
	
	/**
	 * 根据”对象id“ 删除对象
	 * @param id=对象id
	 * @return ReturnResult 
	 */
	@RequestMapping(value = "/{id}/deleteById", method = RequestMethod.GET)
    @ResponseBody
	public Result deleteById(@PathVariable Integer id){

		return this.service.deleteByid(id);

	}
	
	
}
