package com.yunniu.farming.util;

import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.io.*;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpClientUtil {


    public static void main(String[] args) {
        Map<String, String> map = new HashMap<>();
        String url = "https://apis.map.qq.com/ws/geocoder/v1";
//        https://apis.map.qq.com/ws/geocoder/v1/?address=%E4%B8%8A%E6%B5%B7%E5%B8%82%E4%B8%87%E8%BE%BE%E5%B9%BF%E5%9C%BA&key=XWNBZ-DWAWS-IPIOE-6UM7C-3ZITK-RPBSW
        map.put("address", "洛阳市红东方商务楼");
        map.put("key", "XWNBZ-DWAWS-IPIOE-6UM7C-3ZITK-RPBSW");
        String s = doGet(url, map);
        System.out.println(s);
    }

//    {
//        "status": 347,
//            "message": "查询无结果"
//    }


    public static String doGet(String url) {
        return doGet(url, null);
    }

    public static String doGet(String url, Map<String, String> param) {

        // 创建Httpclient对象
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建uri
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();

            // 创建http GET请求
            HttpGet httpGet = new HttpGet(uri);
            // 执行请求
            response = httpclient.execute(httpGet);
            resultString = EntityUtils.toString(response.getEntity(), "UTF-8");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpclient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    public static String doPost(String url) {
        return doPost(url, null);
    }

    public static String doPost(String url, Map<String, String> param) {
        // 创建Httpclient对象
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建Http Post请求
            HttpPost httpPost = new HttpPost(url);
            // 创建参数列表
            if (param != null) {
                List<NameValuePair> paramList = new ArrayList<>();
                for (String key : param.keySet()) {
                    paramList.add(new BasicNameValuePair(key, param.get(key)));
                }
                // 模拟表单
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList);
                httpPost.setEntity(entity);
            }
            // 执行http请求
            response = httpClient.execute(httpPost);
            resultString = EntityUtils.toString(response.getEntity(), "utf-8");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                response.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    public static String doPostJson(String url, String json) {
        // 创建Httpclient对象
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建Http Post请求
            HttpPost httpPost = new HttpPost(url);
            // 创建请求内容
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity(entity);
            // 执行http请求
            response = httpClient.execute(httpPost);
            resultString = EntityUtils.toString(response.getEntity(), "utf-8");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                response.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }


    /**
     * 表单提交参数和文件
     *
     * @param file
     * @return
     */
    public static String postForm(String urlPath, File file) {

        HttpPost httpPost = new HttpPost(urlPath);

        CloseableHttpClient httpClient = HttpClients.createDefault();

        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();

        // 文件参数
        // 用特定的字段名，接收方用对应的字段名接收
        entityBuilder.addPart("fileName", new FileBody(file));
        BufferedReader bufferedReader = null;
        InputStream in = null;
        try {
            HttpEntity httpEntity = entityBuilder.build();
            httpPost.setEntity(httpEntity);

            RequestConfig config = RequestConfig.custom()
                    .setConnectTimeout(20000)
                    .setSocketTimeout(20000) // read time out
                    .build();
            httpPost.setConfig(config); // 请求配置

            CloseableHttpResponse httpResponse = httpClient.execute(httpPost);

            in = httpResponse.getEntity().getContent();
            bufferedReader = new BufferedReader(new InputStreamReader(in, "utf-8"));
            StringBuffer sb = new StringBuffer();
            String readLine = null;
            while ((readLine = bufferedReader.readLine()) != null) {
                sb.append(readLine);
            }
            return sb.toString();
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("请求异常");
            return null;
        } finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (in != null) {
                    in.close();
                }
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }


}
