package com.yunniu.farming.util;

import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.util.Properties;

public class FileUtil {

    public static final String Base = "D:/service";

//    public static final String BasePath = "C://data//upload";

    public static final String BasePath = "/usr/upload";
    //public static final String BasePath = "/upload";

    public static final String Path = "/upload";


    public static String saveFile(MultipartFile file, String objPath) {
        if (file == null) {
            return null;
        }

        // 新的文件名称
        String newFileName = UUIDUtils.getUUID() + "." + file.getContentType().split("/")[1];
        String realpath = BasePath + "/" + objPath + "/" + newFileName;
        // 新的文件
        File newFile = new File(realpath);
        // 文件夹路径不存在
        if (!newFile.exists() && !newFile.isDirectory()) {
            newFile.mkdirs();
        }
        // 将内存中的数据写入磁盘
        try {
            file.transferTo(newFile);
        } catch (IOException e) {
            return null;
        }
        return realpath;
    }


    public static void deleteFiles(String str) {
        if (str != null && !"".equals(str)) {

            String[] arr = str.split(",");
            if (arr.length > 0) {
                for (int i = 0; i < arr.length; i++) {
                    if (arr[i] != null && !"".equals(arr[i])) {
                        File file = new File(Base + arr[i]);
                        // 如果文件路径所对应的文件存在，并且是一个文件，则直接删除
                        if (file.exists() && file.isFile()) {
                            file.delete();
                        }
                    }
                }
            }
        }

    }

    public static void deleteFilesByRealPath(String str) {

        if (str != null && !"".equals(str)) {
            String[] arr = str.split(",");
            if (arr.length > 0) {
                for (int i = 0; i < arr.length; i++) {
                    if (arr[i] != null && !"".equals(arr[i])) {
                        File file = new File(arr[i]);
                        if (file.exists() && file.isFile()) {
                            file.delete();
                        }
                    }
                }
            }
        }

    }

    public static File multipartFileToFile(MultipartFile file) throws Exception {

        File toFile = null;
        if (file.equals("") || file.getSize() <= 0) {
            file = null;
        } else {
            InputStream ins = null;
            ins = file.getInputStream();
            toFile = new File(file.getOriginalFilename());
            inputStreamToFile(ins, toFile);
            ins.close();
        }
        return toFile;
    }

    //获取流文件
    private static void inputStreamToFile(InputStream ins, File file) {
        try {
            OutputStream os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            ins.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public static String getProperties(String keyWord) {
        Properties prop = null;
        String value = null;
        try {
            // 通过Spring中的PropertiesLoaderUtils工具类进行获取
            prop = PropertiesLoaderUtils.loadAllProperties("application.properties");
            // 根据关键字查询相应的值
            value = prop.getProperty(keyWord);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return value;
    }

}
