package com.yunniu.farming.util;


import com.yunniu.farming.common.components.DateUtilBean;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * <p/> 提供日期相关运算方法。
 * <p/>
 * <p> Date: Apr 7, 2011 Time: 10:22:56 AM
 *
 */
@SuppressWarnings("unused")
public class DateUtils {

    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
// -------------------------- STATIC METHODS --------------------------

    /**
     * <p>取得两个时间之间相差的天数,参数类型为Date </p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     *
     * @param startDate 开始的时间
     * @param endDate   结束的时间
     * @return startDate 与  endDate 之间相差的天数
     * @see DateUtilBean#getDaysBetween
     */
    public static int getDaysBetween(Date startDate, Date endDate) {
        return DateUtilBean.getUtilBean().getDaysBetween(startDate, endDate);
    }

    /**
     * <p>取得两个时间之间相差的天数,参数类型为Calendar</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     *
     * @param startDate 开始的时间
     * @param endDate   结束的时间
     * @return startDate 与  endDate 之间相差的天数
     * @see DateUtilBean#getDaysBetween
     */
    public static int getDaysBetween(Calendar startDate, Calendar endDate) {
        return DateUtilBean.getUtilBean().getDaysBetween(startDate, endDate);
    }

    /**
     * <p>Convert String to DateTime .</p>
     * <p> 将 "yyyy-MM-dd HH:mm:ss"转成Calendar .</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     *
     * @param dateTime ： 参数格式为"yyyy-MM-dd HH:mm:ss"
     * @return 根据DATETIME_PATTERN规则 转成的日期
     * @see DateUtilBean#convertToDateTime
     */
    public static Calendar convertToDateTime(String dateTime) {
        return DateUtilBean.getUtilBean().convertToDateTime(dateTime);
    }

    /**
     * <p>Convert String to Date .</p>
     * <p>将字符串"yyyy-MM-dd"转成Calendar类型.</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     *
     * @param date ：参数格式为"yyyy-MM-dd"
     * @return 根据DATE_PATTERN规则 转成的日期
     * @see DateUtilBean#convertToDate
     */
    public static Calendar convertToDate(String date) {
        return DateUtilBean.getUtilBean().convertToDate(date);
    }

    /**
     * <p> Convert String to Month .</p>
     * <p>将字符串"yyyy-MM"转成Calendar类型</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     *
     * @param month : 参数格式为"yyyy-MM"
     * @return 根据MONTH_PATTERN规则 转成的日期
     * @see DateUtilBean#convertToMonth
     */
    public static Calendar convertToMonth(String month) {
        return DateUtilBean.getUtilBean().convertToMonth(month);
    }

    /**
     * <p> Convert DateTime to String  .</p>
     * <p>将Date类型转成字符串"yyyy-MM-dd HH:mm:ss" .</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     *
     * @param date : 待转换的日期
     * @return "yyyy-MM-dd HH:mm:ss"
     * @see DateUtilBean#convertToString
     */
    public static String convertToString(Date date) {
        return DateUtilBean.getUtilBean().convertToString(date);
    }
    /**
     * <p> Convert DateTime to String  .</p>
     * <p>将Date类型转成字符串"yyyy-MM-dd HH:mm:ss" .</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     *
     * @param date : 待转换的日期
     * @return "yyyy-MM-dd HH:mm:ss"
     * @see DateUtilBean#convertToString
     */
    public static String convertToString(Date date, String format) {
    	SimpleDateFormat newDate = new SimpleDateFormat(format);
    	String result="";
    	if(date!=null)
    		result=newDate.format(date);
//        return DateUtilBean.getUtilBean().convertToString(date);
    	return result;
    }

    /**
     * <p> Convert DateTime to String  .</p>
     * <p>将Calendar类型转成字符串"yyyy-MM-dd HH:mm:ss" .</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     *
     * @param date ：待转换的日期
     * @return "yyyy-MM-dd HH:mm:ss"
     * @see DateUtilBean#convertToString
     */
    public static String convertToString(Calendar date) {
        return DateUtilBean.getUtilBean().convertToString(date);
    }

    /**
     * <p>取得一周中的星期几.</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     * <p/>
     * <pre>
     * 范例如下：
     * DateUtils.getDayOfWeek("2010-4-2") = 4（星期五）
     * </pre>
     *
     * @param date : 准备检验的日期
     * @return 具体日期对应的数字
     *         2=星期一、3=星期二、4=星期三、5=星期四、6=星期五、7=星期六、1=星期天
     * @see DateUtilBean#getDayOfWeek
     */
    public static int getDayOfWeek(Calendar date) {
        return DateUtilBean.getUtilBean().getDayOfWeek(date);
    }

    /**
     * getCurrentMonLastDay()
     * <p> 计算当月最后一天,返回那一天 。</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     * <p/>
     * <pre>
     * 范例如下：
     * 本月是4月，则：
     * DateUtils.getCurrentMonLastDay() = "2010-04-30"
     * </pre>
     *
     * @return 返回当月最后一天。
     * @see DateUtilBean#getCurrentMonLastDay
     */
    public static Calendar getCurrentMonLastDay() {
        return DateUtilBean.getUtilBean().getCurrentMonLastDay();
    }

    /**
     * getPreviousMonFirstDay()
     * <p>获取当前月份上一个月的第一天.</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     * <pre>
     * 范例如下：
     * 本月是4月，则：
     * DateUtils.getPreviousMonFirstDay() = "2010-03-01"
     * </pre>
     *
     * @return 当前月份上一个月的第一天。
     * @see DateUtilBean#getPreviousMonFirstDay
     */
    public static Calendar getPreviousMonFirstDay() {
        return DateUtilBean.getUtilBean().getPreviousMonFirstDay();
    }

    /**
     * getPreviousMonLastDay()
     * <p>获取当前月份上个月的最后一天</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     * <pre>
     * 范例如下：
     * 本月是4月，则：
     * DateUtils.getPreviousMonLastDay() = "2010-03-31"
     * </pre>
     *
     * @return 当前月份上个月的最后一天
     * @see DateUtilBean#getPreviousMonLastDay
     */
    public static Calendar getPreviousMonLastDay() {
        return DateUtilBean.getUtilBean().getPreviousMonLastDay();
    }

    /**
     * getPreviousMonFirstDay()
     * <p>获取当月的第一天</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     * <pre>
     * 范例如下：
     * 本月是4月，则：
     * DateUtils.getFirstDayOfMonth() = "2010-04-01"
     * </pre>
     *
     * @return 当月的第一天
     * @see DateUtilBean#getFirstDayOfMonth
     */
    public static Calendar getFirstDayOfMonth() {
        return DateUtilBean.getUtilBean().getFirstDayOfMonth();
    }

    /**
     * getNextMonthFirst()
     * <p>获取下个月的第一天</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     * <pre>
     * 范例如下：
     * 本月是4月，则：
     * DateUtils.getNextMonthFirst() = "2010-05-01"
     * </pre>
     *
     * @return 下个月的第一天
     * @see DateUtilBean#getNextMonthFirst
     */
    public static Calendar getNextMonthFirst() {
        return DateUtilBean.getUtilBean().getNextMonthFirst();
    }

    /**
     * getNextMonthEnd()
     * <p>获取下个月最后一天.</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     * <pre>
     * 范例如下：
     * 本月是4月，则：
     * DateUtils.getNextMonthEnd() = "2010-05-31"
     * </pre>
     *
     * @return 下个月的最后一天
     * @see DateUtilBean#getNextMonthEnd
     */
    public static Calendar getNextMonthEnd() {
        return DateUtilBean.getUtilBean().getNextMonthEnd();
    }

    /**
     * getToday()
     * <p>获得当天的时间 .</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     * <pre>
     * 范例如下：
     * Date date = DateUtils.getToday() = "2010-4-2";
     * </pre>
     *
     * @return 当天的时间
     * @see DateUtilBean#getToday
     */
    public static Calendar getToday() {
        return DateUtilBean.getUtilBean().getToday();
    }

    /**
     * isLeapYear(year)
     * <p>是否闰年.</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     * <pre>
     * 范例如下：
     * year 格式2010,2011
     * DateUtils.isLeapYear(2010) = false
     * DateUtils.isLeapYear(2000) = true
     * </pre>
     *
     * @param year ： 待检验的年份
     * @return 是闰年则返回true 否则返回false
     * @see DateUtilBean#isLeapYear
     */
    public static boolean isLeapYear(int year) {
        return DateUtilBean.getUtilBean().isLeapYear(year);
    }

    /**
     * isBefore(start,end)
     * <p>比较日期start是否在日期end之前.</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     * <pre>
     * 范例如下：
     * <p/>
     * DateUtils.isBefore("2010-4-5","2010-4-6") = true
     * DateUtils.isBefore("2010-4-6","2010-4-6") = false
     * DateUtils.isBefore("2010-4-7","2010-4-6") = false
     * </pre>
     *
     * @param start 时间1
     * @param end   时间2
     * @return 如果日期start在日期end之前返回true,否则返回false.
     * @see DateUtilBean#isBefore
     */
    public static boolean isBefore(Calendar start, Calendar end) {
        return dateCompare(start, end) == -1;
    }

    /**
     * dateCompare(date1,date2)
     * <p>比较两个日期的大小.</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     * <pre>
     * 范例如下：
     * <p/>
     * DateUtils.dateCompare("2010-4-5","2010-4-6") = -1
     * DateUtils.dateCompare("2010-4-6","2010-4-6") = 0
     * DateUtils.dateCompare("2010-4-7","2010-4-6") = 1
     * </pre>
     *
     * @param date1 时间1
     * @param date2 时间2
     * @return 如果date1等于date2 则返回 0, date1在 date2之前则返回-1, date1在date2之后返回1
     * @see DateUtilBean#dateCompare
     */
    public static int dateCompare(Calendar date1, Calendar date2) {
        return DateUtilBean.getUtilBean().dateCompare(date1, date2);
    }

    /**
     * isAfter(start,end)
     * <p>比较日期start是否在日期end之后.</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     * <pre>
     * 范例如下：
     * <p/>
     * DateUtils.isAfter("2010-4-5","2010-4-6") = false
     * DateUtils.isAfter("2010-4-6","2010-4-6") = false
     * DateUtils.isAfter("2010-4-7","2010-4-6") = true
     * </pre>
     *
     * @param start 时间1
     * @param end   时间2
     * @return 如果日期start在日期end之后返回true，否则返回false.
     * @see DateUtilBean#isAfter
     */
    public static boolean isAfter(Calendar start, Calendar end) {
        return dateCompare(start, end) == 1;
    }

    /**
     * isEqual(start,end)
     * <p>比较日期start是否与日期end相等.</p>
     * <p>For more details see <code>DateUtilBean</code>.</p>
     * <pre>
     * 范例如下：
     * <p/>
     * DateUtils.isAfter("2010-4-5","2010-4-6") = false
     * DateUtils.isAfter("2010-4-6","2010-4-6") = true
     * DateUtils.isAfter("2010-4-7","2010-4-6") = false
     * </pre>
     *
     * @param start 时间1
     * @param end   时间2
     * @return 如果日期star与日期end相等返回true，否则返回false.
     * @see DateUtilBean#isEqual
     */
    public static boolean isEqual(Calendar start, Calendar end) {
        return dateCompare(start, end) == 0;
    }

    /**
     * 获得当前日期
     * @return
     */
    public static Calendar getCurDate(){
    	return DateUtils.convertToDate(DateTools.getDate(DEFAULT_DATE_FORMAT));
    }
    
    /**
     * getDaysOfMonth(String monthYear)
     * <p>根据传入的年-月，获取此月的天数</p>
     * 示例：
     *     getDaysOfMonth("2008-02") -- > 29
     *     getDaysOfMonth("2007-03") -- > 31
     *     
     * @param monthYear
     * @return
     */
    public static int getDaysOfMonth(String monthYear){
    	return DateUtilBean.getUtilBean().getDaysOfMonth(monthYear);
    }
    
    /**
     * getDaysOfMonth(String monthYear)
     * <p>根据传入的年份，获取此年的最后一天</p>
     * 示例：
     *     getLastDayOfYear("2008") -- > 2008-12-31
     *     getLastDayOfYear("2007") -- > 2007-12-31
     *     
     * @param monthYear
     * @return
     */
    public static String getLastDayOfYear(String year){
    	year = year + "1231";
    	return DateTools.getDateTool().fmtDate(year, "yyyyMMdd", "yyyy-MM-dd");
    }
    
    /**
     * getDaysOfMonth(String monthYear)
     * <p>根据传入的月份，获取此月的第一天</p>
     * 示例：
     *     getFirstDayOfYear("200208") -- > 20020801
     *     getFirstDayOfYear("2001-07") -- > 2001-07-01
     *     
     * @param monthYear
     * @return
     */
    public static String getFirstDayOfYear(String yearmonth, String fromFormatter, String toformatter){
    	String date = DateTools.getDateTool().fmtDate(yearmonth + "01",fromFormatter,toformatter);
    	return  date;
    }
    
    /**
     * 验证日期格式是否正确
     * @param dateStr
     * @return
     */
    public static boolean validDate(String dateStr){
    	return DateUtilBean.getUtilBean().checkDate(dateStr);
    }
// --------------------------- CONSTRUCTORS ---------------------------

    private DateUtils() {
    	
    }
    
    public static void main(String[] args) {
//    	//System.out.println("CurDate:" + DateUtils.getCurDate());
//    	//System.out.println("days:" + DateUtils.getDaysOfMonth("2008-02"));
//		判断是否含有中文
//    	String chineseStr = "123中华人民公社";  
//    	char[] charArray = chineseStr.toCharArray();  
//    	for(int i=0;i<charArray.length;i++){  
//    	  if ((charArray[i] >= 0x4e00)&&(charArray[i] <= 0x9fbb)){  
//    	    //System.out.println(charArray[i]);
//    	  }       
//    	} 
    }
}
