package com.yunniu.farming.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * <p>Title: 日期工具类</p>
 * <p>Copyright: Copyright (c) 2011</p>
 * <p>Company: easyperfect</p>
 * 
 * @author Frice
 * @version 1.0 2011-7-18
 */
public class DateTools {
	private static final Log log = LogFactory.getLog(DateTools.class);

	public static DateTools getDateTool(){
		return new DateTools();
	}
	
	public static String getDate() {
		return getDate("yyyyMMddHHmmss");
	}

	public static String getDate(String fmt) {
		Date myDate = new Date(System.currentTimeMillis());
		SimpleDateFormat sDateformat = new SimpleDateFormat(fmt);
		return sDateformat.format(myDate).toString();
	}

	private Calendar getCal(String strdate, String fmt) {
		Calendar cal = null;
		try {
			if ((strdate == null) || (fmt == null)) {
				log.error("Error: Method: DateTools.getCal :Incorrect para");
				return cal;
			}
			SimpleDateFormat nowDate = new SimpleDateFormat(fmt);
			Date d = nowDate.parse(strdate, new ParsePosition(0));
			if (d == null) {
				log.fatal("Fatal: Method: DateTools.getCal :Incorrect Parse");
				return cal;
			}
			cal = Calendar.getInstance();
			cal.clear();
			cal.setTime(d);
		} catch (Exception e) {
			log.error("Error: Method: DateTools.getCal :" + e.getMessage());
		}

		return cal;
	}

	public int getWeekOfYear(String strdate, String fmt) {
		int ret = -1;
		try {
			if ((strdate == null) || (fmt == null)) {
				log.error("Error: Method: DateTools.getWeekOfYear :Incorrect para");
				return ret;
			}
			Calendar cal = getCal(strdate, fmt);
			if (cal == null) {
				log.error("Error: Method: DateTools.getWeekOfYear :Incorrect Calendar");
				return ret;
			}
			ret = cal.get(3);
		} catch (Exception e) {
			log.fatal("Fatal: Method: DateTools.getWeekOfYear :"
					+ e.getMessage());
		}

		return ret;
	}

	public String[] getWeekDay(String strdate, String oldfmt, String newfmt) {
		String[] weekday = new String[7];
		try {
			if ((strdate == null) || (oldfmt == null) || (newfmt == null)) {
				log.error("Error: Method: DateTools.getWeekDay :Incorrect para");
				return weekday;
			}
			Calendar cal = getCal(strdate, oldfmt);
			if (cal == null) {
				log.error("Error: Method: DateTools.getWeekDay :Incorrect Calendar");
				return weekday;
			}
			int dayOfWeek = cal.get(7);
			cal.add(5, -dayOfWeek + 2);
			SimpleDateFormat sdf = new SimpleDateFormat(newfmt);
			weekday[0] = sdf.format(cal.getTime());
			for (int i = 1; i < 7; ++i) {
				cal.add(5, 1);
				weekday[i] = sdf.format(cal.getTime());
			}
		} catch (IndexOutOfBoundsException iobe) {
			log.fatal("Fatal: Method: DateTools.getWeekDay :"
					+ iobe.getMessage());
		}

		return weekday;
	}

	public String[] getWeekDate(String year, int week, String newfmt) {
		String[] jweekday = new String[7];
		try {
			if ((year == null) || (year.length() < 4) || (week <= 0)
					|| (newfmt == null)) {
				log.error("Error: Method: DateTools.getWeekDate :Incorrect para");
				return jweekday;
			}
			Calendar cal = getCal(year + "0101", "yyyyMMdd");
			if (cal == null) {
				log.error("Error: Method: DateTools.getWeekDate :Incorrect Calendar");
				return jweekday;
			}
			--week;
			cal.add(5, week * 7 - cal.get(7) + 2);
			SimpleDateFormat sdf = new SimpleDateFormat(newfmt);
			jweekday[0] = sdf.format(cal.getTime());
			for (int i = 1; i < 7; ++i) {
				cal.add(5, 1);
				jweekday[i] = sdf.format(cal.getTime());
			}
		} catch (IndexOutOfBoundsException iobe) {
			log.fatal("Fatal: Method: DateTools.getWeekDate :"
					+ iobe.getMessage());
		}

		return jweekday;
	}

	public String getDayOfWeek(String strdate, String oldfmt, String fmt) {
		String sWeek = null;
		try {
			if ((strdate == null) || (oldfmt == null) || (fmt == null)) {
				log.error("Error: Method: DateTools.getDayOfWeek :Incorrect para");
				return sWeek;
			}
			Calendar cal = getCal(strdate, oldfmt);
			if (cal == null) {
				log.error("Error: Method: DateTools.getDayOfWeek :Incorrect Calendar");
				return sWeek;
			}
			int iWeek = cal.get(7);
			sWeek = fmt + ((iWeek - 1 == 0) ? 7 : iWeek - 1);
		} catch (Exception e) {
			log.fatal("Fatal: Method: DateTools.getDayOfWeek :"
					+ e.getMessage());
		}

		return sWeek;
	}

	public int getWeekNum(String year) {
		int weeknum = -1;
		try {
			if (year == null) {
				log.error("Error: Method: DateTools.getWeekNum :Incorrect para");
				return weeknum;
			}
			Calendar cal = getCal(year + "1231", "yyyyMMdd");
			if (cal == null) {
				log.error("Error: Method: DateTools.getWeekNum :Incorrect Calendar");
				return weeknum;
			}
			if (cal.get(3) == 1)
				cal.add(5, -7);
			weeknum = cal.get(3);
		} catch (Exception e) {
			log.fatal("Fatal: Method: DateTools.getWeekNum :"
					+ e.getMessage());
		}

		return weeknum;
	}

	public String getNextWeek(String year, int week, int next) {
		String ret = null;
		try {
			if ((year == null) || (week <= 0)) {
				log.error("Error: Method: DateTools.getNextWeek :Incorrect para");
				return ret;
			}
			String[] weekday = getWeekDate(year, week, "yyyyMMdd");
			Calendar cal = getCal(weekday[0], "yyyyMMdd");
			if (cal == null) {
				log.error("Error: Method: DateTools.getNextWeek :Incorrect Calendar");
				return ret;
			}
			cal.add(5, 7 * next);
			if (next > 0)
				cal.add(5, 6);
			SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
			String nextweekday = sdf.format(cal.getTime());
			int weekofyear = getWeekOfYear(nextweekday, "");
			ret = nextweekday.substring(0, 4) + Integer.toString(weekofyear);
		} catch (Exception e) {
			log.fatal("Fatal: Method: DateTools.getNextWeek :"
					+ e.getMessage());
		}

		return ret;
	}


	public String getBeforeTime(String deftime, String oldfmt, int timediff,
                                String newfmt) {
		return getBeforeTimeBym(deftime, oldfmt, timediff * 60, newfmt);
	}

	public String getBeforeTimeBym(String deftime, String oldfmt, int timediff,
                                   String newfmt) {
		String rq = null;
		try {
			if ((deftime == null) || (deftime.equals(""))) {
				log.error("Error: Method: DateTools.getBeforeTime :Incorrect para");
				return rq;
			}
			Calendar cal = getCal(deftime, oldfmt);
			if (cal == null) {
				log.error("Error: Method: DateTools.getBeforeTime :Incorrect Calendar");
				return rq;
			}
			cal.add(12, -timediff);
			SimpleDateFormat sdf = new SimpleDateFormat(newfmt);
			rq = sdf.format(cal.getTime());
		} catch (Exception e) {
			log.fatal("Fatal: Method: DateTools.getBeforeTime :"
					+ e.getMessage());
		}

		return rq;
	}

	public String getBeforeTimeByM(String deftime, String oldfmt, int timediff,
                                   String newfmt) {
		String rq = null;
		try {
			if ((deftime == null) || (deftime.equals(""))) {
				log.error("Error: Method: DateTools.getBeforeTime :Incorrect para");
				return rq;
			}
			Calendar cal = getCal(deftime, oldfmt);
			if (cal == null) {
				log.error("Error: Method: DateTools.getBeforeTime :Incorrect Calendar");
				return rq;
			}
			cal.add(2, -timediff);
			SimpleDateFormat sdf = new SimpleDateFormat(newfmt);
			rq = sdf.format(cal.getTime());
		} catch (Exception e) {
			log.fatal("Fatal: Method: DateTools.getBeforeTime :"
					+ e.getMessage());
		}

		return rq;
	}

	public String fmtDate(String mydate, String oldfmt, String newfmt) {
		String restr = null;
		try {
			if ((mydate == null) || (oldfmt == null) || (newfmt == null)) {
				log.error("Error: Method: DateTools.fmtDate :Incorrect para");
				return restr;
			}
			SimpleDateFormat newDate = new SimpleDateFormat(newfmt);
			Calendar cal = getCal(mydate, oldfmt);
			if (cal == null) {
				log.error("Error: Method: DateTools.fmtDate :Incorrect Calendar");
				return restr;
			}
			restr = newDate.format(cal.getTime());
		} catch (Exception e) {
			log.fatal("Fatal: Method: DateTools.fmtDate :"
							+ e.getMessage());
		}

		return restr;
	}

   /** 
    * 获取未来 第 past 天的日期 
    * @param past 
    * @return 
    */  
   public static String getDateLater(int past) {
       Calendar calendar = Calendar.getInstance();
       calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) + past);
       Date today = calendar.getTime();
       SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
       String result = format.format(today);
       //Log.e(null, result);  
       return result;  
   } 
   
	public static void main(String[] args) {
		DateTools dt = new DateTools();
		try {
			//System.out.println(dt.getWeekOfYear("20040526", "yyyyMMdd"));
			//System.out.println(dt.getWeekNum("2004"));
			//System.out.println(dt.getNextWeek("2004", 51, 2));
			//System.out.println(dt.getWeekOfYear("20041225", "yyyyMMdd"));
			//System.out.println(dt.getWeekOfYear("20050101", "yyyyMMdd"));
			//System.out.println(dt.getWeekOfYear("20050102", "yyyyMMdd"));
			//System.out.println(dt.fmtDate("2006", "yyyy", "yyyy-MM-dd"));
			
			////System.out.println(dt.getDateLater(7));
			
			//System.out.println(Integer.parseInt("1"));
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}