package com.yunniu.farming.util;

import com.alibaba.fastjson.JSONObject;
import org.springframework.web.client.RestTemplate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Common {

    // 生成18位订单号
    public static String getDateNumber() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        Date date = new Date();
        String str = sdf.format(date).substring(2, 17) + getRandomCode(4);
        return str;
    }

    // sum位数验证码
    public static String getRandomCode(int sum) {
        String str = "";
        for (int i = 0; i < sum; i++) {
            int a = (int) (Math.random() * 10);
            str = str + a;
        }
        return str;
    }


    private static double EARTH_RADIUS = 6378.137;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    /**
     * 通过经纬度获取距离(单位：千米)
     *
     * @param lat1
     * @param lng1
     * @param lat2
     * @param lng2
     * @return 距离
     */
    public static double getDistance(double lat1, double lng1, double lat2,
                                     double lng2) {
        double radLat1 = rad(lat1);
        double radLat2 = rad(lat2);
        double a = radLat1 - radLat2;
        double b = rad(lng1) - rad(lng2);
        double s = 2 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2), 2)
                + Math.cos(radLat1) * Math.cos(radLat2)
                * Math.pow(Math.sin(b / 2), 2)));
        s = s * EARTH_RADIUS;
        s = Math.round(s * 10000d) / 10000d;
        return s;
    }


    public static String setOpenCode(String startTime, String endTime, String eqpId) {
        //3770738730
        startTime = datePlus(startTime, 10);
        endTime = datePlus(endTime, 0);
        //3770738730
        String str = "{\n" +
                "\"access_token\": \"418e0d47f909d0f3366ecc6c949973c49fc7a0054ddc125d\", \n" +
                "\"operation\": \"POST\",\n" +
                "\"data\":{\n" +
                "\t\"dev_sn_list\": [\"" + eqpId + "\"], \n" +
                "\t\"pwd_type\": 2,\n" +
                "\t\"memo\": \"\",\n" +
                "\t\"start_datetime\": \"" + startTime + "\", \n" +
                "\t\"end_datetime\": \"" + endTime + "\",\n" +
                "\t\"use_count\":0\n" +
                "} \n" +
                "\t\n" +
                "}";
        String url = "https://www.doormaster.me:9099/doormaster/server/devices/temp_pwd";
        RestTemplate restTemplate = new RestTemplate();
        String a = restTemplate.postForObject(url, str, String.class);
        System.out.println(a);

        System.out.println("设置锁返回结果:" + a);
        JSONObject resjo = JSONObject.parseObject(a);
        String qrcode_content = (String) resjo.get("qrcode_content");
        return qrcode_content;
    }

    public static String datePlus(String d, int min) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmSS");
        Date date = null;
        try {
            date = sf.parse(d);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        //五分钟就是300000毫秒
        Date nextDate = new Date(date.getTime() + 60000 * min);
        return sf.format(nextDate);
    }


    public static Integer getMinutesFromTo(String fromDate, String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            long from = sdf.parse(fromDate).getTime();
            long to = sdf.parse(endDate).getTime();
            int minutes = (int) ((to - from) / (1000 * 60));
            return minutes;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Integer getMinutesFromNow(String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String fromDate = sdf.format(new Date());
        System.out.println(fromDate);
        try {
            long from = sdf.parse(fromDate).getTime();
            long to = sdf.parse(endDate).getTime();
            int minutes = (int) ((to - from) / (1000 * 60));
            return minutes;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }
}
