package com.yunniu.farming.shiro;

import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class MyFormAuthenticationFilter extends FormAuthenticationFilter {
    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (isLoginRequest(request, response)) {
            if (isLoginSubmission(request, response)) {
                // 本次用户登陆账号
                String account = this.getUsername(request);

                Subject subject = this.getSubject(request, response);
                // 之前登陆的用户
//                Admin user = (Admin) subject.getPrincipal();
//                // 如果两次登陆的用户不一样，则先退出之前登陆的用户
//                if (account != null && user != null && !account.equals(user.getAdminAccount())) {
//                    subject.logout();
//                }
            }
        }

        return super.isAccessAllowed(request, response, mappedValue);
    }

    @Override  //登录拦截到首页
    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        String successUrl = "/index";
        WebUtils.issueRedirect(request, response, successUrl);
        System.out.println("登录首页拦截");
        return false;
    }
}