package com.yunniu.farming.result;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;

@Data
public class Result {

    /**
     * 响应代码
     */
    private String code;

    /**
     * 响应消息
     */
    private String msg;

    /**
     * 响应结果
     */
    private Object data;

    public Result() {
        this.code = CommonEnum.SUCCESS.getResultCode();
        this.msg = CommonEnum.SUCCESS.getResultMsg();
    }

    public Result(BaseError errorInfo) {
        this.code = errorInfo.getResultCode();
        this.msg = errorInfo.getResultMsg();
    }

    public Result(Object data) {
        this.code = CommonEnum.SUCCESS.getResultCode();
        this.msg = CommonEnum.SUCCESS.getResultMsg();
        this.data = data;
    }


    /**
     * 成功
     *
     * @return
     */
    public static Result success() {
        return success(null);
    }

    public static Result success(String msg) {
        Result rb = new Result();
        rb.setCode(CommonEnum.SUCCESS.getResultCode());
        rb.setMsg(msg);
        return rb;
    }

    /**
     * 成功
     *
     * @param data
     * @return
     */
    public static Result success(Object data) {
        Result rb = new Result();
        rb.setCode(CommonEnum.SUCCESS.getResultCode());
        rb.setMsg(CommonEnum.SUCCESS.getResultMsg());
        rb.setData(data);
        return rb;
    }

    /**
     * 成功
     *
     * @param data
     * @return
     */
    public static Result success(String msg, Object data) {
        Result rb = new Result();
        rb.setCode(CommonEnum.SUCCESS.getResultCode());
        rb.setMsg(msg);
        rb.setData(data);
        return rb;
    }


    /**
     * 失败
     */
    public static Result error() {
        Result rb = new Result();
        rb.setCode("500");
        rb.setMsg("发生错误");
        rb.setData(null);
        return rb;
    }


    /**
     * 失败
     */
    public static Result error(BaseError errorInfo) {
        Result rb = new Result();
        rb.setCode(errorInfo.getResultCode());
        rb.setMsg(errorInfo.getResultMsg());
        rb.setData(null);
        return rb;
    }

    /**
     * 失败
     */
    public static Result error(String code, String msg) {
        Result rb = new Result();
        rb.setCode(code);
        rb.setMsg(msg);
        rb.setData(null);
        return rb;
    }


    public static Result error(String code, String msg, Object data) {
        Result rb = new Result();
        rb.setCode(code);
        rb.setMsg(msg);
        rb.setData(data);
        return rb;
    }

    /**
     * 失败
     */
    public static Result error(String msg) {
        Result rb = new Result();
        rb.setCode("-1");
        rb.setMsg(msg);
        rb.setData(null);
        return rb;
    }

    public static Result error(Object data, String msg) {
        Result rb = new Result();
        rb.setCode("-1");
        rb.setMsg(msg);
        rb.setData(data);
        return rb;
    }

    @Override
    public String toString() {
        return JSONObject.toJSONString(this);
    }
}
