package com.yunniu.farming.common.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.List;

/**
 * 分页对象
 * @author Administrator
 *
 */
public class PageInfo implements Serializable {

    private static final long serialVersionUID = 587754556498974978L;

    // pagesize ，每一页显示多少
    private int pageSize = 10;
    // 总页数
    private int totalPages = 0;
    // 总记录数
    private int totalRecords = 0;
    // 当前页数：默认查询第一页
    private int curPage = 1;
    
    // 当前的记录的条数，意为从第“N”条记录开始查询，
    // 在mysql中 select ... limit arg1,arg2 中就是第一个参数arg1；
    // 第二个参数是 arg2，意为  这一次查询要查询几条记录，就是每页的记录数.
    private int curRecord = 0;//默认从第0条开始查询
    
    //排序相关
    private List<String> sortFields;
    private List<String> sortMode;
    
    public static final String SORT_DESC = "DESC";
    public static final String SORT_ASC = "ASC";
    
	public int getPageSize() {
		return pageSize;
	}
	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}
	public int getTotalPages() {
		return totalPages;
	}
	public void setTotalPages(int totalPages) {
		this.totalPages = totalPages;
	}
	public int getTotalRecords() {
		return totalRecords;
	}
	public void setTotalRecords(int totalRecords) {
		this.totalRecords = totalRecords;
	}
	public int getCurPage() {
		return curPage;
	}
	public void setCurPage(int curPage) {
		this.curPage = curPage;
	}
	public int getCurRecord() {
		return curRecord;
	}
	public void setCurRecord(int curRecord) {
		this.curRecord = curRecord;
	}
	public List<String> getSortFields() {
		return sortFields;
	}
	public void setSortFields(List<String> sortFields) {
		this.sortFields = sortFields;
	}
	public List<String> getSortMode() {
		return sortMode;
	}
	public void setSortMode(List<String> sortMode) {
		this.sortMode = sortMode;
	}
	
	@Override
    public String toString(){
    	return JSONObject.toJSONString(this);
    }
	
	public JSONObject toJSON() {
    	return JSON.parseObject(this.toString());
    }
}
