package com.yunniu.farming.common.exceptions;

/**
 *<p> 业务运行时异常 </p>
 *@date 2011-08-10  
 *@author Frice
 *@since v0.1
 */
public class BusinessException extends ApplicationException {
// ------------------------------ FIELDS ------------------------------

    public static final int errorCode = 12000;
    public static final int errorCodeNoLogin = 12001;//未登录
    public static final int errorCodeTokenExpire = 12002;//token失效

// --------------------------- CONSTRUCTORS ---------------------------

    public BusinessException(final String message) {
        super(message);
    }

    public BusinessException(final Throwable cause) {
        super(cause);
    }

    public BusinessException(final String message, final Throwable cause) {
        super(message, cause);
    }

    public BusinessException(final Throwable cause, final int errorCode) {
        super(cause, errorCode);
    }

    public BusinessException(final String message, final int errorCode) {
        super(message, errorCode);
    }

    public BusinessException(final String message, final Throwable cause, final int errorCode) {
        super(message, cause, errorCode);
    }
}

