package com.yunniu.farming.common.exceptions;


import org.apache.log4j.Logger;

/**
 *<p> 运行时异常 </p>
 *@date 2011-08-10  
 *@author Frice
 *@since v0.1
 */
@SuppressWarnings("unused")
public class ApplicationException extends RuntimeException {
// ------------------------------ FIELDS ------------------------------

    /**
	 *
	 */
	public static int errorCode = 10000;

// --------------------------- CONSTRUCTORS ---------------------------

    public ApplicationException(final String message) {
        super(message);
        log();
    }

    public ApplicationException(final Throwable cause) {
        super(cause);
        log();
    }

    public ApplicationException(final String message, final Throwable cause) {
        super(message, cause);
        log();
    }

    public ApplicationException(final Throwable cause,
                                final int errorCode) {
        super(cause);
        this.errorCode = errorCode;
        log();
    }

    public ApplicationException(final String message,
                                final int errorCode) {
        super(message + ", ErrorCode:" + errorCode);
        this.errorCode = errorCode;
        log();
    }

    public ApplicationException(final String message,
                                final Throwable cause,
                                final int errorCode) {
        super(message + ", ErrorCode:" + errorCode, cause);
        this.errorCode = errorCode;
        log();
    }

// -------------------------- OTHER METHODS --------------------------

    protected Logger getLogger() {
        return Logger.getLogger(this.getClass());
    }

    protected void log() {
        getLogger().error(this.getMessage(), this);
    }
}
