package com.yunniu.farming.app;

import com.alibaba.fastjson.JSONObject;
import com.yunniu.farming.config.ReturnResult;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.model.Banner;
import com.yunniu.farming.webadmin.model.SysSet;
import com.yunniu.farming.webadmin.service.impl.SysSetServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * @功能：系统参数
 */
@RestController
@CrossOrigin(origins = "*", maxAge = 3600)
@RequestMapping("/app/sysset")
public class SysSetAppController {
	

	@Autowired
	private SysSetServiceImpl service;


	/**
	 * 新增
	 */
	@RequestMapping(value = "/add",method = RequestMethod.POST)
	@ResponseBody
	public Result add(@RequestBody JSONObject json){
		SysSet item = JSONObject.toJavaObject(json,SysSet.class);
		return this.service.add(item);
	}
	
	/**
	 * 带参查询
	 */
	@RequestMapping(value = "/findByParam",method = RequestMethod.POST)
	@ResponseBody
	public Result findByEntity(){

		SysSet docs = this.service.findByParam();

		return Result.success(docs);

	}

	
	/**
	 * 根据id查找
	 */
	@RequestMapping(value = "/{id}/findByid", method = RequestMethod.GET)
    @ResponseBody
	public Result findById(@PathVariable Integer id){

		return this.service.finById(id);

	}


	/**
	 * 根据id更新
	 */
	@RequestMapping(value = "/updateById",method = RequestMethod.POST)
	@ResponseBody
	public ReturnResult updateById(@RequestBody JSONObject json){
		
		//1. 将前台传过来的json对象转换成具有业务属性的 Java 对象
		SysSet user = JSONObject.toJavaObject(json,SysSet.class);
		
		//2. 调用service方法
		int result = this.service.update(user);
		
		return ReturnResult.getSuccessResult(result);
	}




	@RequestMapping(value = "/getBanner", method = RequestMethod.POST)
	@ResponseBody
	public Banner getBanner() {
		return service.getBanner();
	}


}
