package com.yunniu.farming.app;

import com.alibaba.fastjson.JSONObject;
import com.yunniu.farming.common.plugin.PageInfo;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.model.Integralrec;
import com.yunniu.farming.webadmin.service.impl.IntegralrecServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/app/integralrec")
public class IntegralrecAppController {
	/**
	 * 系统用户Service 注册
	 */
	@Autowired
	private IntegralrecServiceImpl service;
	//---------------------增、删、改、查方法------------------------
	
	/**
	 * 新增、编辑 方法
	 */
	@RequestMapping(value = "/add",method = RequestMethod.POST)
	@ResponseBody
	public Result add(@RequestBody JSONObject json){
		
		Integralrec user = JSONObject.toJavaObject(json,Integralrec.class);

		return this.service.add(user);
		
	}
	
	
	/**
	 * 根据 ”多参数“ 查找对象集合
	 */
	@RequestMapping(value = "/findByParam",method = RequestMethod.POST)
	@ResponseBody
	public Result findByParam(@RequestBody JSONObject json){

		Integralrec item = JSONObject.toJavaObject(json,Integralrec.class);
		
		List<Integralrec> docs = this.service.findByParam(item);
		
		return Result.success(docs);
	}
	
	

	/**
	 * 根据 多参数 分页查找 对象集合
	 * 注意：这里分页是通过分页插件拦截器实现的，分页相关的数据是通过 查询参数对象 又重新返回了
	 * @return
	 */
	@RequestMapping(value = "/findPageList", method = RequestMethod.POST)
	@ResponseBody
	public Result findPageList(@RequestBody Integralrec item){
		
		//这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
		Map<String,Object> rmap = new HashMap<String,Object>();

		//传入当前页数，适配PC端Layui分页
		if(item.getCurpage() != null || item.getPagesize() != null) {
			PageInfo pinfo = new PageInfo();
			
			if(item.getCurpage() != null) {
				pinfo.setCurPage(item.getCurpage());
			}
			
			if(item.getPagesize() != null) {
				pinfo.setPageSize(item.getPagesize());
			}
			item.setPageinfo(pinfo);
		}
		// 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
		PageInfo pinfo = item.getPageinfo();
	
		if(pinfo == null) {
			pinfo = new PageInfo();
			item.setPageinfo(pinfo);
		}else{
			// 分页开始记录数
			int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
			pinfo.setCurRecord(curRecord);
			item.setPageinfo(pinfo);
		}
		
		// 2.1 执行主表 查询
		List<Integralrec> items = this.service.findByParamPageList(item);

		
		// 3.将查询结果的 分页数据封装后返回
		int totalRs = pinfo.getTotalRecords();		//总记录数
		int totalPs = 0;					  		//总页数
		if(totalRs % pinfo.getPageSize() == 0){		//总页数计算
			totalPs = totalRs / pinfo.getPageSize() ;
		}else{
			totalPs = 1 + totalRs / pinfo.getPageSize() ;
		}
		pinfo.setTotalPages(totalPs);
		
		// 4.将分页对象、结果集合 封装后返回前台
		rmap.put("pageinfo", pinfo);
		rmap.put("items", items);
		
		return Result.success(rmap);
		
	}	

	/**
	 * 根据”对象id“ 查找对象
	 */
	@RequestMapping(value = "/{id}/findByid", method = RequestMethod.GET)
	@ResponseBody
	public Result findById(@PathVariable Integer id){
		
		Integralrec u = this.service.findByid(id);
		
		return Result.success(u);
	}
	
	/**
	 * 根据”对象id“ 删除对象
	 */
	@RequestMapping(value = "/{id}/deleteByid", method = RequestMethod.GET)
    @ResponseBody
	public Result deleteById(@PathVariable Integer id){
		//1. 调用Service方法
		int deleteR = this.service.deleteByid(id);
	
		//2. 返回查询结果
		return Result.success(deleteR);
	}
	
	//-------------------其他 业务方法-------------------------
	/**
	 * 统计积分余额
	 */
	@RequestMapping(value = "/sumIntegral", method = RequestMethod.POST)
    @ResponseBody
	public Result sumIntegral(@RequestBody Integralrec item){

		Double inte = this.service.sumIntegral(item);
	
		return Result.success(inte);
	}
	
}
